/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.http;

import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.connector.http.proxy.NashornProxyPacResolver;
import org.nuxeo.connect.connector.http.proxy.ProxyPacResolver;

public class ProxyHelper {
    protected static boolean useNTLM = false;
    public static ProxyPacResolver pacResolver = new NashornProxyPacResolver();
    protected static String PROXY_PAC_DIRECT = "DIRECT";

    @Deprecated
    public static void configureProxyIfNeeded(HttpClientBuilder httpClientBuilder, String url) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        ProxyHelper.configureProxyIfNeeded(requestConfigBuilder, (CredentialsProvider)credentialsProvider, url);
        httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    public static void configureProxyIfNeeded(RequestConfig.Builder requestConfigBuilder, CredentialsProvider credentialsProvider, String url) {
        if (ConnectUrlConfig.useProxy()) {
            HttpHost proxyHost = null;
            if (ConnectUrlConfig.useProxyPac()) {
                String[] proxy = pacResolver.findProxy(url);
                if (proxy != null) {
                    proxyHost = new HttpHost(proxy[0], Integer.parseInt(proxy[1]));
                }
            } else {
                proxyHost = new HttpHost(ConnectUrlConfig.getProxyHost(), ConnectUrlConfig.getProxyPort());
            }
            if (proxyHost != null) {
                requestConfigBuilder.setProxy(proxyHost);
                if (ConnectUrlConfig.isProxyAuthenticated()) {
                    AuthScope authScope = new AuthScope(proxyHost.getHostName(), proxyHost.getPort(), AuthScope.ANY_REALM);
                    if (ConnectUrlConfig.isProxyNTLM()) {
                        NTCredentials ntlmCredential = new NTCredentials(ConnectUrlConfig.getProxyLogin(), ConnectUrlConfig.getProxyPassword(), ConnectUrlConfig.getProxyNTLMHost(), ConnectUrlConfig.getProxyNTLMDomain());
                        credentialsProvider.setCredentials(authScope, (Credentials)ntlmCredential);
                    } else {
                        UsernamePasswordCredentials ba = new UsernamePasswordCredentials(ConnectUrlConfig.getProxyLogin(), ConnectUrlConfig.getProxyPassword());
                        credentialsProvider.setCredentials(authScope, (Credentials)ba);
                    }
                }
            }
        }
    }
}

