/*
 * (C) Copyright 2016-2016 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Nuxeo
 *     Yannis JULIENNE
 *
 */

package org.nuxeo.connect.connector.fake;

import org.nuxeo.connect.update.PackageType;

/**
 * Fake implementation
 *
 * @author <a href="mailto:td@nuxeo.com">Thierry Delprat</a>
 * @deprecated since 1.4
 */
@Deprecated
public class UnregistredFakeConnector extends AbstractFakeConnector {

    @Override
    protected String getJSONDataForDownloads(String type) {
        String data = null;
        if (PackageType.HOT_FIX.getValue().equals(type)) {
            data = "[ ]";
        } else if (PackageType.STUDIO.getValue().equals(type)) {
            data = "[ ]";
        } else if (PackageType.ADDON.getValue().equals(type)) {
            // get feed for advertised addons
            data = "[ ]";
        }

        return data;
    }

    @Override
    protected String getJSONDataForStatus() {
        return "{ contractStatus : 'unregistered', endDate : ''}";
    }

    @Override
    protected String getJSONDataForDownload(String pkgId) {
        throw new UnsupportedOperationException();
    }

}
