/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.utils.Vars;

public final class StringUtils {
    private static final String PLAIN_ASCII = "AaEeIiOoUuAaEeIiOoUuYyAaEeIiOoUuYyAaEeIiOoUuYyAaEeIiOoUuYyAaCc";
    private static final String UNICODE = "\u00c0\u00e0\u00c8\u00e8\u00cc\u00ec\u00d2\u00f2\u00d9\u00f9\u00c1\u00e1\u00c9\u00e9\u00cd\u00ed\u00d3\u00f3\u00da\u00fa\u00dd\u00fd\u00c2\u00e2\u00ca\u00ea\u00ce\u00ee\u00d4\u00f4\u00db\u00fb\u0176\u0177\u00c2\u00e2\u00ca\u00ea\u00ce\u00ee\u00d4\u00f4\u00db\u00fb\u0176\u0177\u00c4\u00e4\u00cb\u00eb\u00cf\u00ef\u00d6\u00f6\u00dc\u00fc\u0178\u00ff\u00c5\u00e5\u00c7\u00e7";

    private StringUtils() {
    }

    public static String toAscii(String s, boolean normalize) {
        if (normalize) {
            s = Normalizer.normalize(s, Normalizer.Form.NFC);
        }
        StringBuilder sb = new StringBuilder();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            int pos = UNICODE.indexOf(c);
            if (pos > -1) {
                sb.append(PLAIN_ASCII.charAt(pos));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toAscii(String s) {
        return StringUtils.toAscii(s, false);
    }

    public static List<String> split(String str, char delimiter, char escape, boolean trim) {
        if (delimiter == escape) {
            throw new IllegalArgumentException("Delimiter cannot be the escape character");
        }
        ArrayList<String> ar = new ArrayList<String>();
        if (str.isEmpty()) {
            ar.add(str);
            return ar;
        }
        StringBuilder segment = new StringBuilder();
        int i = 0;
        int length = str.length();
        boolean lastCharDelimiter = false;
        while (i < length) {
            char c = str.charAt(i);
            if (c == escape) {
                if (i < length - 2) {
                    char nextC = str.charAt(i + 1);
                    if (nextC == delimiter || nextC == escape) {
                        segment.append(nextC);
                        i += 2;
                        continue;
                    }
                    segment.append(c);
                    ++i;
                    continue;
                }
                segment.append(c);
                ++i;
                continue;
            }
            if (c == delimiter) {
                ar.add(trim ? segment.toString().trim() : segment.toString());
                segment = new StringBuilder();
                if (i == length - 1) {
                    lastCharDelimiter = true;
                }
                ++i;
                continue;
            }
            segment.append(c);
            ++i;
        }
        if (segment.length() > 0 || lastCharDelimiter) {
            ar.add(trim ? segment.toString().trim() : segment.toString());
        }
        return ar;
    }

    public static String[] split(String str, char delimiter, boolean trim) {
        int s = 0;
        int e = str.indexOf(delimiter, s);
        if (e == -1) {
            if (trim) {
                str = str.trim();
            }
            return new String[]{str};
        }
        ArrayList<String> ar = new ArrayList<String>();
        do {
            String segment = str.substring(s, e);
            if (trim) {
                segment = segment.trim();
            }
            ar.add(segment);
        } while ((e = str.indexOf(delimiter, s = e + 1)) != -1);
        int len = str.length();
        if (s < len) {
            String segment = str.substring(s);
            if (trim) {
                segment = segment.trim();
            }
            ar.add(segment);
        } else {
            ar.add("");
        }
        return ar.toArray(new String[ar.size()]);
    }

    public static String expandVars(String expression, Map<?, ?> properties) {
        return Vars.expand(expression, properties);
    }
}

