/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.io.StringReader;
import java.util.Collection;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.Path;
import org.nuxeo.common.xmap.XAnnotatedList;
import org.nuxeo.common.xmap.XAnnotatedMap;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DOMHelper {
    private DOMHelper() {
    }

    public static String getNodeValue(Element base, Path path) {
        Node node = DOMHelper.getElementNode((Node)base, path);
        if (node != null) {
            if (path.attribute != null) {
                Node at = node.getAttributes().getNamedItem(path.attribute);
                return at != null ? at.getNodeValue() : null;
            }
            return node.getTextContent();
        }
        return null;
    }

    public static void visitNodes(Context ctx, XAnnotatedList xam, Element base, Path path, NodeVisitor visitor, Collection<Object> result) {
        Node el = base;
        int len = path.segments.length - 1;
        for (int i = 0; i < len; ++i) {
            if ((el = DOMHelper.getElementNode(el, path.segments[i])) != null) continue;
            return;
        }
        String name = path.segments[len];
        if (path.attribute != null) {
            DOMHelper.visitAttributes(ctx, xam, el, name, path.attribute, visitor, result);
        } else {
            DOMHelper.visitElements(ctx, xam, el, name, visitor, result);
        }
    }

    public static void visitAttributes(Context ctx, XAnnotatedList xam, Node base, String name, String attrName, NodeVisitor visitor, Collection<Object> result) {
        for (Node p = base.getFirstChild(); p != null; p = p.getNextSibling()) {
            Node at;
            if (p.getNodeType() != 1 || !name.equals(p.getNodeName()) || (at = p.getAttributes().getNamedItem(attrName)) == null) continue;
            visitor.visitNode(ctx, xam, at, result);
        }
    }

    public static void visitElements(Context ctx, XAnnotatedList xam, Node base, String name, NodeVisitor visitor, Collection<Object> result) {
        for (Node p = base.getFirstChild(); p != null; p = p.getNextSibling()) {
            if (p.getNodeType() != 1 || !name.equals(p.getNodeName())) continue;
            visitor.visitNode(ctx, xam, p, result);
        }
    }

    public static void visitMapNodes(Context ctx, XAnnotatedMap xam, Element base, Path path, NodeMapVisitor visitor, Map<String, Object> result) {
        Node el = base;
        int len = path.segments.length - 1;
        for (int i = 0; i < len; ++i) {
            if ((el = DOMHelper.getElementNode(el, path.segments[i])) != null) continue;
            return;
        }
        String name = path.segments[len];
        if (path.attribute != null) {
            DOMHelper.visitMapAttributes(ctx, xam, el, name, path.attribute, visitor, result);
        } else {
            DOMHelper.visitMapElements(ctx, xam, el, name, visitor, result);
        }
    }

    public static void visitMapAttributes(Context ctx, XAnnotatedMap xam, Node base, String name, String attrName, NodeMapVisitor visitor, Map<String, Object> result) {
        for (Node p = base.getFirstChild(); p != null; p = p.getNextSibling()) {
            String key;
            Node at;
            if (p.getNodeType() != 1 || !name.equals(p.getNodeName()) || (at = p.getAttributes().getNamedItem(attrName)) == null || (key = DOMHelper.getNodeValue((Element)p, xam.key)) == null) continue;
            visitor.visitNode(ctx, xam, at, key, result);
        }
    }

    public static void visitMapElements(Context ctx, XAnnotatedMap xam, Node base, String name, NodeMapVisitor visitor, Map<String, Object> result) {
        for (Node p = base.getFirstChild(); p != null; p = p.getNextSibling()) {
            String key;
            if (p.getNodeType() != 1 || !name.equals(p.getNodeName()) || (key = DOMHelper.getNodeValue((Element)p, xam.key)) == null) continue;
            visitor.visitNode(ctx, xam, p, key, result);
        }
    }

    public static Node getElementNode(Node base, String name) {
        for (Node node = base.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !name.equals(node.getNodeName())) continue;
            return node;
        }
        return null;
    }

    public static Node getElementNode(Node base, Path path) {
        Node el = base;
        int len = path.segments.length;
        for (int i = 0; i < len; ++i) {
            if ((el = DOMHelper.getElementNode(el, path.segments[i])) != null) continue;
            return null;
        }
        return el;
    }

    public static void loadFragment(Element el, String fragment) {
        fragment = "<fragment>" + fragment + "</fragment>";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document d = factory.newDocumentBuilder().parse(new InputSource(new StringReader(fragment)));
            Document doc = el.getOwnerDocument();
            Node node = doc.importNode(d.getDocumentElement(), true);
            DocumentFragment docfrag = doc.createDocumentFragment();
            while (node.hasChildNodes()) {
                el.appendChild(node.removeChild(node.getFirstChild()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NodeMapVisitor {
        public void visitNode(Context var1, XAnnotatedMember var2, Node var3, String var4, Map<String, Object> var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NodeVisitor {
        public void visitNode(Context var1, XAnnotatedMember var2, Node var3, Collection<Object> var4);
    }
}

