/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLStreamHandlerFactoryInstaller {
    private static final FactoryStack factoryStack = new FactoryStack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installURLStreamHandlerFactory(URLStreamHandlerFactory shf) throws Exception {
        Object lock;
        Field factoryField = URLStreamHandlerFactoryInstaller.getStaticField(URL.class, URLStreamHandlerFactory.class);
        if (factoryField == null) {
            throw new Exception("Could not find URLStreamHandlerFactory field");
        }
        Object object = lock = URLStreamHandlerFactoryInstaller.getURLStreamHandlerFactoryLock();
        synchronized (object) {
            URLStreamHandlerFactory factory = (URLStreamHandlerFactory)factoryField.get(null);
            if (factory == null) {
                factoryStack.push(shf);
            } else if (factory != factoryStack) {
                factoryStack.push(factory);
                factoryStack.push(shf);
            } else {
                factoryStack.push(shf);
            }
            factoryField.set(null, null);
            URL.setURLStreamHandlerFactory(factoryStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uninstallURLStreamHandlerFactory() {
        try {
            Object lock;
            Field factoryField = URLStreamHandlerFactoryInstaller.getStaticField(URL.class, URLStreamHandlerFactoryInstaller.class);
            if (factoryField == null) {
                return;
            }
            Object object = lock = URLStreamHandlerFactoryInstaller.getURLStreamHandlerFactoryLock();
            synchronized (object) {
                URLStreamHandlerFactory factory = (URLStreamHandlerFactory)factoryField.get(null);
                if (factory != null && factory == factoryStack) {
                    factoryStack.pop();
                }
                factoryField.set(null, null);
                URL.setURLStreamHandlerFactory(factoryStack);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Field getStaticField(Class<?> clazz, Class<?> type) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(type)) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    private static Object getURLStreamHandlerFactoryLock() throws IllegalAccessException {
        Object lock;
        try {
            Field streamHandlerLockField = URL.class.getDeclaredField("streamHandlerLock");
            streamHandlerLockField.setAccessible(true);
            lock = streamHandlerLockField.get(null);
        }
        catch (NoSuchFieldException noField) {
            lock = URL.class;
        }
        return lock;
    }

    public static FactoryStack getStack() {
        return factoryStack;
    }

    public static class FactoryStack
    implements URLStreamHandlerFactory {
        final ArrayList<URLStreamHandlerFactory> factories = new ArrayList();

        public URLStreamHandler createURLStreamHandler(String protocol) {
            for (int i = this.factories.size() - 1; i >= 0; --i) {
                URLStreamHandler h = this.factories.get(i).createURLStreamHandler(protocol);
                if (h == null) continue;
                return h;
            }
            return null;
        }

        public void push(URLStreamHandlerFactory factory) {
            this.factories.add(factory);
        }

        public URLStreamHandlerFactory pop() {
            if (this.factories.isEmpty()) {
                return null;
            }
            return this.factories.remove(this.factories.size() - 1);
        }

        public URLStreamHandlerFactory peek() {
            if (this.factories.isEmpty()) {
                return null;
            }
            return this.factories.get(this.factories.size() - 1);
        }

        public boolean isEmpty() {
            return this.factories.isEmpty();
        }

        public int size() {
            return this.factories.size();
        }

        public void clear() {
            this.factories.clear();
        }
    }
}

