/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.debug;

import java.util.Hashtable;
import java.util.Map;

public final class Profiler {
    private static final Map<String, CheckPoint> checkpoints = new Hashtable<String, CheckPoint>();

    private Profiler() {
    }

    public static void checkpoint(String name) {
        checkpoints.put(name, new CheckPoint());
    }

    public static void print(String name) {
        CheckPoint cp = checkpoints.get(name);
        if (cp != null) {
            double tm = new CheckPoint().timeElapsed(cp);
            System.out.println("### " + name + " > " + tm + " sec.");
        } else {
            System.out.println("### " + name + " > N/A");
        }
    }

    static class CheckPoint {
        public final long timestamp = System.currentTimeMillis();

        CheckPoint() {
        }

        public final double timeElapsed(CheckPoint cp) {
            return ((double)this.timestamp - (double)cp.timestamp) / 1000.0;
        }
    }
}

