/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextTemplate {
    private static final Pattern PATTERN = Pattern.compile("\\$\\{([a-zA-Z_0-9\\-\\.]+)\\}");
    private final Map<String, String> vars = new HashMap<String, String>();

    public TextTemplate() {
    }

    public TextTemplate(Map<String, String> vars) {
        this.vars.putAll(vars);
    }

    public void setVariables(Map<String, String> vars) {
        this.vars.putAll(vars);
    }

    public Map<String, String> getVariables() {
        return this.vars;
    }

    public void setVariable(String name, String value) {
        this.vars.put(name, value);
    }

    public String getVariable(String name) {
        return this.vars.get(name);
    }

    public String process(CharSequence text) {
        Matcher m = PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String var = m.group(1);
            String value = this.getVariable(var);
            if (value == null) continue;
            m.appendReplacement(sb, value);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public String process(InputStream in) throws IOException {
        String text = FileUtils.read(in);
        return this.process(text);
    }

    public void process(InputStream in, OutputStream out) throws IOException {
        String text = FileUtils.read(in);
        out.write(this.process(text).getBytes());
    }
}

