/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    private static final String PLAIN_ASCII = "AaEeIiOoUuAaEeIiOoUuYyAaEeIiOoUuYyAaEeIiOoUuYyAaEeIiOoUuYyAaCc";
    private static final String UNICODE = "\u00c0\u00e0\u00c8\u00e8\u00cc\u00ec\u00d2\u00f2\u00d9\u00f9\u00c1\u00e1\u00c9\u00e9\u00cd\u00ed\u00d3\u00f3\u00da\u00fa\u00dd\u00fd\u00c2\u00e2\u00ca\u00ea\u00ce\u00ee\u00d4\u00f4\u00db\u00fb\u0176\u0177\u00c2\u00e2\u00ca\u00ea\u00ce\u00ee\u00d4\u00f4\u00db\u00fb\u0176\u0177\u00c4\u00e4\u00cb\u00eb\u00cf\u00ef\u00d6\u00f6\u00dc\u00fc\u0178\u00ff\u00c5\u00e5\u00c7\u00e7";

    private StringUtils() {
    }

    public static String toAscii(String s) {
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            int pos = UNICODE.indexOf(c);
            if (pos > -1) {
                sb.append(PLAIN_ASCII.charAt(pos));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String join(Object[] array) {
        if (array == null) {
            return null;
        }
        int arraySize = array.length;
        int bufSize = arraySize == 0 ? 0 : ((array[0] == null ? 16 : array[0].toString().length()) + 1) * arraySize;
        StringBuffer buf = new StringBuffer(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        int arraySize = array.length;
        int bufSize = arraySize == 0 ? 0 : ((array[0] == null ? 16 : array[0].toString().length()) + 1) * arraySize;
        StringBuffer buf = new StringBuffer(bufSize);
        buf.append(array[0]);
        for (int i = 1; i < arraySize; ++i) {
            if (separator != null) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Object[] array, char separator) {
        return StringUtils.join(array, String.valueOf(separator));
    }

    public static String join(List<String> list, String separator) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return "";
        }
        int seplen = separator == null ? 0 : separator.length();
        int len = -seplen;
        for (String s : list) {
            len += seplen;
            if (s == null) continue;
            len += s.length();
        }
        StringBuffer buf = new StringBuffer(len);
        boolean first = true;
        for (String s : list) {
            if (first) {
                first = false;
            } else if (seplen != 0) {
                buf.append(separator);
            }
            if (s == null) continue;
            buf.append(s);
        }
        return buf.toString();
    }

    public static String join(List<String> list) {
        return StringUtils.join(list, null);
    }

    public static String join(List<String> list, char separator) {
        return StringUtils.join(list, String.valueOf(separator));
    }

    public static String[] split(String str, char delimiter, boolean trim) {
        int s = 0;
        int e = str.indexOf(delimiter, s);
        if (e == -1) {
            if (trim) {
                str = str.trim();
            }
            return new String[]{str};
        }
        ArrayList<String> ar = new ArrayList<String>();
        do {
            String segment = str.substring(s, e);
            if (trim) {
                segment = segment.trim();
            }
            ar.add(segment);
        } while ((e = str.indexOf(delimiter, s = e + 1)) != -1);
        int len = str.length();
        if (s < len) {
            String segment = str.substring(s);
            if (trim) {
                segment = segment.trim();
            }
            ar.add(segment);
        } else {
            ar.add("");
        }
        return ar.toArray(new String[ar.size()]);
    }

    public static String toHex(String string) {
        char[] chars = string.toCharArray();
        StringBuffer buf = new StringBuffer();
        for (char c : chars) {
            buf.append(Integer.toHexString(c).toUpperCase());
        }
        return buf.toString();
    }

    public static String expandVars(String expression, Map<? extends Object, ? extends Object> properties) {
        int p = expression.indexOf("${");
        if (p == -1) {
            return expression;
        }
        char[] buf = expression.toCharArray();
        StringBuffer result = new StringBuffer(buf.length);
        if (p > 0) {
            result.append(expression.substring(0, p));
        }
        StringBuffer varBuf = new StringBuffer();
        boolean dollar = false;
        boolean var = false;
        block5: for (int i = p; i < buf.length; ++i) {
            char c = buf[i];
            switch (c) {
                case '$': {
                    dollar = true;
                    continue block5;
                }
                case '{': {
                    if (!dollar) continue block5;
                    dollar = false;
                    var = true;
                    continue block5;
                }
                case '}': {
                    if (!var) continue block5;
                    var = false;
                    String varName = varBuf.toString();
                    varBuf.setLength(0);
                    Object varValue = properties.get(varName);
                    if (varValue != null) {
                        result.append(varValue.toString());
                        continue block5;
                    }
                    result.append("${").append(varName).append("}");
                    continue block5;
                }
                default: {
                    if (var) {
                        varBuf.append(c);
                        continue block5;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }
}

