/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.mailbox;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.cm.exception.CaseManagementException;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.mailbox.MailboxConstants;
import org.nuxeo.cm.service.MailboxManagementService;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBound;
import org.nuxeo.cm.web.mailbox.CaseManagementAbstractActionsBean;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.UserAction;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModel;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.pagination.ResultsProvidersCache;

@Name(value="cmMailboxActions")
@Scope(value=ScopeType.CONVERSATION)
@CaseManagementContextBound
public class CaseManagementMailboxActionsBean
extends CaseManagementAbstractActionsBean {
    private static final long serialVersionUID = 1L;
    protected static String MAILBOX_INBOX = "MAILBOX_INBOX";
    protected static String MAILBOX_SERVICE = "MAILBOX_SERVICE";
    protected static String MAILBOX_SENT = "MAILBOX_SENT";
    protected static String MAILBOX_DRAFT = "MAILBOX_DRAFT";
    protected static String MAILBOX_PLANS = "MAILBOX_PLANS";
    protected static final Log log = LogFactory.getLog(CaseManagementMailboxActionsBean.class);
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true)
    protected transient MailboxManagementService mailboxManagementService;
    @In(required=false)
    protected transient Principal currentUser;
    protected List<Mailbox> userMailboxes;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @RequestParameter
    protected String mailboxSuggestionSearchType;
    protected String parentMailboxId;

    public Object getMailboxSuggestions(Object input) throws ClientException {
        String searchPattern = (String)input;
        String searchType = this.mailboxSuggestionSearchType;
        if (searchType == null || StringUtils.isEmpty((String)searchType)) {
            searchType = null;
        }
        return this.mailboxManagementService.searchMailboxes(this.documentManager, searchPattern, searchType);
    }

    @Factory(value="userMailboxes", scope=ScopeType.EVENT)
    public List<Mailbox> getUserMailboxes() throws CaseManagementException {
        if (this.userMailboxes == null) {
            this.userMailboxes = new ArrayList<Mailbox>();
            if (this.currentUser != null) {
                Mailbox personalMailbox = null;
                List mailboxes = this.mailboxManagementService.getUserMailboxes(this.documentManager, this.currentUser.getName());
                if (mailboxes != null && !mailboxes.isEmpty()) {
                    this.userMailboxes.addAll(mailboxes);
                    Iterator<Mailbox> it = this.userMailboxes.iterator();
                    while (it.hasNext()) {
                        Mailbox mbox = it.next();
                        if (!MailboxConstants.type.personal.name().equals(mbox.getType()) || !this.currentUser.getName().equals(mbox.getOwner())) continue;
                        personalMailbox = mbox;
                        it.remove();
                        break;
                    }
                }
                Collections.sort(this.userMailboxes, new Comparator<Mailbox>(){

                    @Override
                    public int compare(Mailbox o1, Mailbox o2) {
                        return o1.getTitle().compareTo(o2.getTitle());
                    }
                });
                if (personalMailbox != null) {
                    this.userMailboxes.add(0, personalMailbox);
                }
            }
        }
        return this.userMailboxes;
    }

    public void validateMailboxId(FacesContext context, UIComponent component, Object value) {
        if (!(value instanceof String) || this.mailboxManagementService.hasMailbox(this.documentManager, (String)value)) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"feedback.casemanagement.mailboxIdAlreadyExists"), null);
            throw new ValidatorException(message);
        }
    }

    public void validatePersonalMailboxCreation(FacesContext context, UIComponent component, Object value) {
        String mbId;
        Map attributes = component.getAttributes();
        String mailboxTypeInputId = (String)attributes.get("mailboxTypeInputId");
        String mailboxOwnerInputId = (String)attributes.get("mailboxOwnerInputId");
        if (mailboxTypeInputId == null || mailboxOwnerInputId == null) {
            log.error((Object)"Cannot validate personal mailbox creation: input id(s) not found");
            return;
        }
        UIInput mailboxTypeComp = (UIInput)component.findComponent(mailboxTypeInputId);
        UIInput mailboxOwnerComp = (UIInput)component.findComponent(mailboxOwnerInputId);
        if (mailboxTypeComp == null || mailboxOwnerComp == null) {
            log.error((Object)"Cannot validate personal mailbox creation: input(s) not found");
            return;
        }
        Object mailboxType = mailboxTypeComp.getLocalValue();
        Object mailboxOwner = mailboxOwnerComp.getLocalValue();
        if (mailboxType == null || mailboxOwner == null) {
            log.error((Object)"Cannot validate personal mailbox creation: value(s) not found");
            return;
        }
        if (MailboxConstants.type.personal.name().equals(mailboxType) && this.mailboxManagementService.hasMailbox(this.documentManager, mbId = this.mailboxManagementService.getUserPersonalMailboxId((String)mailboxOwner))) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"feedback.casemanagement.personalMailboxAlreadyExists"), null);
            throw new ValidatorException(message);
        }
    }

    public String createMailbox() throws CaseManagementException {
        try {
            DocumentModel newDocument = this.navigationContext.getChangeableDocument();
            if (newDocument.getId() != null) {
                log.debug((Object)("Document " + newDocument.getName() + " already created"));
                return this.navigationContext.navigateToDocument(newDocument, "after-create");
            }
            DocumentModel parentDocument = this.getParentMailbox(this.parentMailboxId);
            this.resetParentMailboxId();
            String parentDocumentPath = parentDocument.getPathAsString();
            String title = (String)((Object)newDocument.getPropertyValue("dc:title"));
            if (title == null) {
                title = "";
            }
            String name = IdUtils.generateId((String)title);
            newDocument.setPathInfo(parentDocumentPath, name);
            newDocument = this.documentManager.createDocument(newDocument);
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("document_saved"), new Object[]{this.resourcesAccessor.getMessages().get(newDocument.getType())});
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{parentDocument});
            return this.navigationContext.navigateToDocument(newDocument, "after-create");
        }
        catch (Throwable t) {
            throw new CaseManagementException(t);
        }
    }

    @Factory(value="inboxChildrenSelectModel", scope=ScopeType.EVENT)
    public SelectDataModel getInboxSelectModel() throws ClientException {
        return this.getSelectDataModelFromProvider(MAILBOX_INBOX);
    }

    @Factory(value="serviceChildrenSelectModel", scope=ScopeType.EVENT)
    public SelectDataModel getServicelectModel() throws ClientException {
        return this.getSelectDataModelFromProvider(MAILBOX_SERVICE);
    }

    @Factory(value="sentChildrenSelectModel", scope=ScopeType.EVENT)
    public SelectDataModel getSentSelectModel() throws ClientException {
        return this.getSelectDataModelFromProvider(MAILBOX_SENT);
    }

    @Factory(value="draftChildrenSelectModel", scope=ScopeType.EVENT)
    public SelectDataModel getDraftSelectModel() throws ClientException {
        return this.getSelectDataModelFromProvider(MAILBOX_DRAFT);
    }

    @Factory(value="plansChildrenSelectModel", scope=ScopeType.EVENT)
    public SelectDataModel getPlansSelectModel() throws ClientException {
        return this.getSelectDataModelFromProvider(MAILBOX_PLANS);
    }

    @Override
    protected void resetMailboxCache(Mailbox cachedMailbox, Mailbox newMailbox) throws ClientException {
        ResultsProvidersCache resultsProvidersCache = (ResultsProvidersCache)Component.getInstance((String)"resultsProvidersCache");
        resultsProvidersCache.invalidate(MAILBOX_INBOX);
        resultsProvidersCache.invalidate(MAILBOX_SERVICE);
        resultsProvidersCache.invalidate(MAILBOX_SENT);
        resultsProvidersCache.invalidate(MAILBOX_DRAFT);
        resultsProvidersCache.invalidate(MAILBOX_PLANS);
        super.resetMailboxCache(cachedMailbox, newMailbox);
    }

    protected DocumentModel getMailboxRoot() throws ClientException {
        DocumentModelList res = this.documentManager.query(String.format("SELECT * from %s", "MailboxRoot"));
        if (res == null || res.isEmpty()) {
            throw new CaseManagementException("Cannot find any mailbox root");
        }
        return (DocumentModel)res.get(0);
    }

    protected DocumentModel getParentMailbox(String parentMailboxId) throws ClientException {
        DocumentModel mailboxDoc = null;
        if (parentMailboxId != null && !StringUtils.isEmpty((String)parentMailboxId)) {
            try {
                mailboxDoc = this.mailboxManagementService.getMailbox(this.documentManager, parentMailboxId).getDocument();
            }
            catch (Exception e) {
                log.error((Object)String.format("Unable to find parent mailbox with id '%s', using default mailbox root as parent", parentMailboxId));
            }
        }
        if (mailboxDoc == null) {
            mailboxDoc = this.getMailboxRoot();
        }
        return mailboxDoc;
    }

    public String getParentMailboxId() {
        return this.parentMailboxId;
    }

    public void setParentMailboxId(String parentMailboxId) {
        this.parentMailboxId = parentMailboxId;
    }

    public void resetParentMailboxId() {
        this.parentMailboxId = null;
    }

    public Boolean isGenericMailbox() throws ClientException {
        Mailbox currentMailbox = this.getCurrentMailbox();
        if (currentMailbox == null) {
            return false;
        }
        DocumentModel doc = this.getCurrentMailbox().getDocument();
        if (!doc.hasFacet("Mailbox")) {
            return false;
        }
        Mailbox mailbox = (Mailbox)doc.getAdapter(Mailbox.class);
        String type2 = mailbox.getType();
        return type2.equals(MailboxConstants.type.generic.name());
    }

    public String addCaseItem(String type2) throws ClientException {
        DocumentModel changeableDocument = this.documentManager.createDocumentModel(type2);
        this.navigationContext.setChangeableDocument(changeableDocument);
        return this.navigationContext.getActionResult(changeableDocument, UserAction.CREATE);
    }

    public String createDraftCaseItem(String type2) throws ClientException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("parentPath", "/case-management/case-root");
        context.put("eventContextMailboxId", this.getCurrentMailbox().getId());
        context.put("eventContextAffiliatedMailboxId", this.getCurrentMailbox().getAffiliatedMailboxId());
        DocumentModel changeableDocument = this.documentManager.createDocumentModel(type2, context);
        this.navigationContext.setChangeableDocument(changeableDocument);
        return this.navigationContext.getActionResult(changeableDocument, UserAction.CREATE);
    }

    public void updateManagerTabMailbox() throws ClientException {
        Mailbox mailbox = this.getCurrentMailbox();
        mailbox.save(this.documentManager);
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.delegation.modified"), new Object[0]);
        EventManager.raiseEventsOnDocumentChange((DocumentModel)mailbox.getDocument());
    }

    public String getCurrentMailboxParent() throws ClientException {
        Mailbox mailbox = this.getCurrentMailbox();
        return mailbox.getParentId(this.documentManager);
    }

    public String openDraft(String envelopeId) throws ClientException {
        return this.navigationContext.navigateToId(envelopeId);
    }

    public String readCaseLink(String caseLinkId, String caseDocumentId, Boolean read) throws ClientException {
        if (!read.booleanValue()) {
            DocumentModel caseLink = this.documentManager.getDocument((DocumentRef)new IdRef(caseLinkId));
            caseLink.setPropertyValue("cslk:isRead", (Serializable)Boolean.TRUE);
            this.documentManager.saveDocument(caseLink);
        }
        return this.navigationContext.navigateToId(caseDocumentId);
    }
}

