/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.helper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.service.MailboxManagementService;
import org.nuxeo.cm.web.mailbox.CaseManagementMailboxActionsBean;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webapp.helpers.StartupHelper;
import org.nuxeo.runtime.api.Framework;

@Name(value="startupHelper")
@Scope(value=ScopeType.SESSION)
@Install(precedence=30)
public class CaseManagementStartupHelper
extends StartupHelper {
    private static final long serialVersionUID = -3606085944027894437L;
    private static final Log log = LogFactory.getLog(CaseManagementStartupHelper.class);
    @In(create=true)
    protected transient CaseManagementMailboxActionsBean cmMailboxActions;
    @In(create=true)
    protected transient NuxeoPrincipal currentNuxeoPrincipal;

    public String initServerAndFindStartupPage() throws ClientException {
        String page = super.initServerAndFindStartupPage();
        this.initCurrentDomain();
        try {
            MailboxManagementService service = (MailboxManagementService)Framework.getService(MailboxManagementService.class);
            String user = this.currentNuxeoPrincipal.getName();
            Mailbox userMailbox = service.getUserPersonalMailbox(this.documentManager, user);
            if (userMailbox != null) {
                page = this.navigationContext.navigateToDocument(userMailbox.getDocument());
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not redirect to user mailbox", (Throwable)e);
        }
        return page;
    }

    protected void initCurrentDomain() throws ClientException {
        DocumentModel rootDocument;
        if (this.documentManager == null) {
            this.documentManager = this.navigationContext.getOrCreateDocumentManager();
        }
        if (this.documentManager.hasPermission((rootDocument = this.documentManager.getRootDocument()).getRef(), "ReadChildren")) {
            DocumentModelList domains = this.documentManager.getChildren(rootDocument.getRef());
            if (domains.size() > 0) {
                this.navigationContext.setCurrentDocument((DocumentModel)domains.get(0));
            } else {
                log.warn((Object)"No domain found: cannot set current document");
            }
        }
    }
}

