/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.noear.solon.serialization.JsonConverter;
import org.noear.solon.serialization.JsonRenderFactory;

public abstract class JacksonRenderFactoryBase
implements JsonRenderFactory {
    protected SimpleModule module;

    public abstract ObjectMapper config();

    protected void registerModule() {
        if (this.module != null) {
            this.config().registerModule((Module)this.module);
        }
    }

    public <T> void addEncoder(Class<T> clz, JsonSerializer<T> encoder) {
        if (this.module == null) {
            this.module = new SimpleModule();
        }
        this.module.addSerializer(clz, encoder);
    }

    public <T> void addConvertor(Class<T> clz, final JsonConverter<T> converter) {
        this.addEncoder(clz, new JsonSerializer<T>(){

            public void serialize(T source, JsonGenerator out, SerializerProvider sp) throws IOException {
                Object val = converter.convert(source);
                if (val == null) {
                    out.writeNull();
                } else if (val instanceof String) {
                    out.writeString((String)val);
                } else if (val instanceof Number) {
                    if (val instanceof Integer || val instanceof Long) {
                        out.writeNumber(((Number)val).longValue());
                    } else {
                        out.writeNumber(((Number)val).doubleValue());
                    }
                } else {
                    throw new IllegalArgumentException("The result type of the converter is not supported: " + val.getClass().getName());
                }
            }
        });
    }
}

