/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.health;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.core.handle.Result;
import org.noear.solon.health.HealthCheckResult;
import org.noear.solon.health.HealthIndicator;
import org.noear.solon.health.HealthStatus;

public class HealthChecker {
    private static final Map<String, HealthIndicator> indicatorMap = new ConcurrentHashMap<String, HealthIndicator>();

    public static void addIndicator(String name, HealthIndicator indicator) {
        indicatorMap.put(name, indicator);
    }

    public static HealthCheckResult check() {
        LinkedHashMap details = new LinkedHashMap();
        HealthCheckResult healthResult = new HealthCheckResult();
        healthResult.setDetails(details);
        indicatorMap.forEach((name, indicator) -> {
            HealthCheckResult checkResult = HealthChecker.checkItem(healthResult, indicator);
            details.put(name, checkResult);
        });
        return healthResult;
    }

    private static HealthCheckResult checkItem(HealthCheckResult healthResult, HealthIndicator indicator) {
        HealthCheckResult checkResult = new HealthCheckResult();
        try {
            Result result = indicator.get();
            checkResult.setDetails(result.getData());
            if (result.getCode() == Result.SUCCEED_CODE) {
                checkResult.setStatus(HealthStatus.UP);
            } else {
                checkResult.setStatus(HealthStatus.DOWN);
                if (healthResult.getStatus().ordinal() < HealthStatus.DOWN.ordinal()) {
                    healthResult.setStatus(HealthStatus.DOWN);
                }
            }
        }
        catch (Throwable e) {
            checkResult.setStatus(HealthStatus.ERROR);
            checkResult.setDetails(e.getMessage());
            healthResult.setStatus(HealthStatus.ERROR);
        }
        return checkResult;
    }
}

