/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cache;

import java.util.Properties;
import java.util.function.Supplier;
import org.noear.solon.cache.jedis.RedisCacheService;
import org.noear.solon.cache.spymemcached.MemCacheService;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.data.cache.LocalCacheService;

public class CacheServiceSupplier
implements Supplier<CacheService> {
    private CacheService real;
    private String driverType;

    public CacheServiceSupplier(Properties props) {
        this.driverType = props.getProperty("driverType");
        if ("local".equals(this.driverType)) {
            this.real = new LocalCacheService(props);
        } else if ("redis".equals(this.driverType)) {
            this.real = new RedisCacheService(props);
        } else if ("memcached".equals(this.driverType)) {
            this.real = new MemCacheService(props);
        } else {
            throw new IllegalArgumentException("There is no supported driverType");
        }
    }

    @Override
    public CacheService get() {
        return this.real;
    }
}

