/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.socketd.smartsocket;

import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.prop.impl.SocketServerProps;
import org.noear.solon.boot.socketd.smartsocket.AioServerProcessor;
import org.noear.solon.boot.socketd.smartsocket._SessionManagerImpl;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.socketd.SessionManager;
import org.noear.solon.socketd.SocketProps;
import org.noear.solon.socketd.client.smartsocket.AioProtocol;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.transport.AioQuickServer;

public final class XPluginImp
implements Plugin {
    private static Signal _signal;
    private AioQuickServer _server = null;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "smartsocket-socketd 1.5/" + Solon.cfg().version();
    }

    public void start(AopContext context) {
        SessionManager.register((SessionManager)new _SessionManagerImpl());
        if (!Solon.app().enableSocketD()) {
            return;
        }
        context.beanOnloaded(ctx -> this.start0(Solon.app()));
    }

    private void start0(SolonApp app) {
        ServerProps.init();
        long time_start = System.currentTimeMillis();
        LogUtil.global().info("Server:main: SmartSocket 1.5(smartsocket-socketd)");
        SocketServerProps props = new SocketServerProps(20000);
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        try {
            this._server = Utils.isEmpty((String)_host) ? new AioQuickServer(_port, (Protocol)AioProtocol.instance, (MessageProcessor)new AioServerProcessor()) : new AioQuickServer(_host, _port, (Protocol)AioProtocol.instance, (MessageProcessor)new AioServerProcessor());
            this._server.setThreadNum(props.getCoreThreads());
            this._server.setBannerEnabled(false);
            if (SocketProps.readBufferSize() > 0) {
                this._server.setReadBufferSize(SocketProps.readBufferSize());
            }
            if (SocketProps.writeBufferSize() > 0) {
                this._server.setWriteBuffer(SocketProps.writeBufferSize(), 16);
            }
            this._server.start();
            _signal = new SignalSim(_name, _host, _port, "tcp", SignalType.SOCKET);
            app.signalAdd(_signal);
            long time_end = System.currentTimeMillis();
            LogUtil.global().info("Connector:main: smartsocket-socketd: Started ServerConnector@{[Socket]}{0.0.0.0:" + _port + "}");
            LogUtil.global().info("Server:main: smartsocket-socketd: Started @" + (time_end - time_start) + "ms");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.shutdown();
            this._server = null;
            LogUtil.global().info("Server:main: smartsocket-socketd: Has Stopped " + XPluginImp.solon_boot_ver());
        }
    }
}

