/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jlhttp;

import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.jlhttp.HTTPServer;
import org.noear.solon.boot.jlhttp.JlHttpServerComb;
import org.noear.solon.boot.prop.impl.HttpServerProps;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.LogUtil;

public final class XPluginImp
implements Plugin {
    private static Signal _signal;
    JlHttpServerComb _server;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "jlhttp 2.6/" + Solon.version();
    }

    public void start(AppContext context) {
        if (!Solon.app().enableHttp()) {
            return;
        }
        if (ClassUtil.loadClass((String)"org.noear.solon.boot.jetty.XPluginImp") != null) {
            return;
        }
        if (ClassUtil.loadClass((String)"org.noear.solon.boot.undertow.XPluginImp") != null) {
            return;
        }
        if (ClassUtil.loadClass((String)"org.noear.solon.boot.smarthttp.XPluginImp") != null) {
            return;
        }
        context.lifecycle(99, () -> this.start0(Solon.app()));
    }

    private void start0(SolonApp app) throws Throwable {
        ServerProps.init();
        HttpServerProps props = new HttpServerProps();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        long time_start = System.currentTimeMillis();
        if (ServerProps.request_maxHeaderSize > 0) {
            HTTPServer.MAX_HEADER_SIZE = ServerProps.request_maxHeaderSize;
        }
        if (ServerProps.request_maxBodySize > 0L) {
            HTTPServer.MAX_BODY_SIZE = ServerProps.request_maxBodySize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)ServerProps.request_maxBodySize;
        }
        this._server = new JlHttpServerComb();
        this._server.setExecutor(props.getBioExecutor("jlhttp-"));
        this._server.setHandler(arg_0 -> ((SolonApp)Solon.app()).tryHandle(arg_0));
        EventBus.publish((Object)this._server);
        this._server.start(_host, _port);
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "http", SignalType.HTTP);
        app.signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String serverUrl = props.buildServerUrl(this._server.isSecure());
        LogUtil.global().info("Connector:main: jlhttp: Started ServerConnector@{HTTP/1.1,[http/1.1]}{" + serverUrl + "}");
        LogUtil.global().info("Server:main: jlhttp: Started (" + XPluginImp.solon_boot_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            LogUtil.global().info("Server:main: jlhttp: Has Stopped (" + XPluginImp.solon_boot_ver() + ")");
        }
    }
}

