/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jlhttp;

import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.jlhttp.HTTPServer;
import org.noear.solon.boot.jlhttp.JlHttpContextHandler;
import org.noear.solon.boot.ssl.SslConfig;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.lang.Nullable;

public class JlHttpServer
implements ServerLifecycle {
    private HTTPServer server = null;
    private Handler handler;
    private Executor executor;
    private SslConfig sslConfig = new SslConfig("http");
    private boolean isSecure;

    public boolean isSecure() {
        return this.isSecure;
    }

    public void enableSsl(boolean enable, @Nullable SSLContext sslContext) {
        this.sslConfig.set(enable, sslContext);
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void start(String host, int port) throws Throwable {
        this.server = new HTTPServer();
        if (this.sslConfig.isSslEnable()) {
            this.server.setServerSocketFactory(this.sslConfig.getSslContext().getServerSocketFactory());
            this.isSecure = true;
        }
        HTTPServer.VirtualHost virtualHost = this.server.getVirtualHost(null);
        virtualHost.setDirectoryIndex(null);
        virtualHost.addContext("/", new JlHttpContextHandler(this.handler), "*");
        this.server.setExecutor(this.executor);
        this.server.setPort(port);
        if (Utils.isNotEmpty((String)host)) {
            this.server.setHost(host);
        }
        this.server.start();
    }

    public void stop() throws Throwable {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }
}

