/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.stream;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.StreamAcceptor;
import org.noear.socketd.transport.core.StreamAcceptorBase;
import org.noear.socketd.transport.core.StreamManger;
import org.noear.socketd.transport.core.internal.ChannelDefault;
import org.noear.socketd.utils.RunUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamMangerDefault
implements StreamManger {
    private static Logger log = LoggerFactory.getLogger(ChannelDefault.class);
    private final Config config;
    private final Map<String, StreamAcceptorBase> acceptorMap = new ConcurrentHashMap<String, StreamAcceptorBase>();

    public StreamMangerDefault(Config config) {
        this.config = config;
    }

    @Override
    public void addAcceptor(String sid, StreamAcceptorBase acceptor) {
        this.acceptorMap.put(sid, acceptor);
        if (this.config.getStreamTimeout() > 0L) {
            acceptor.insuranceFuture = RunUtils.delay(() -> this.acceptorMap.remove(sid), this.config.getStreamTimeout());
        }
    }

    @Override
    public StreamAcceptor getAcceptor(String sid) {
        return this.acceptorMap.get(sid);
    }

    @Override
    public void removeAcceptor(String sid) {
        StreamAcceptorBase acceptor = this.acceptorMap.remove(sid);
        if (acceptor != null) {
            if (acceptor.insuranceFuture != null) {
                acceptor.insuranceFuture.cancel(false);
            }
            if (log.isDebugEnabled()) {
                log.debug("{} acceptor removed, sid={}", (Object)this.config.getRoleName(), (Object)sid);
            }
        }
    }
}

