/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.listener;

import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;

public class PipelineListener
implements Listener {
    protected final Deque<Listener> deque = new LinkedList<Listener>();

    public PipelineListener prev(Listener listener) {
        this.deque.addFirst(listener);
        return this;
    }

    public PipelineListener next(Listener listener) {
        this.deque.addLast(listener);
        return this;
    }

    public int size() {
        return this.deque.size();
    }

    @Override
    public void onOpen(Session session) throws IOException {
        for (Listener listener : this.deque) {
            listener.onOpen(session);
        }
    }

    @Override
    public void onMessage(Session session, Message message) throws IOException {
        for (Listener listener : this.deque) {
            listener.onMessage(session, message);
        }
    }

    @Override
    public void onClose(Session session) {
        for (Listener listener : this.deque) {
            listener.onClose(session);
        }
    }

    @Override
    public void onError(Session session, Throwable error) {
        for (Listener listener : this.deque) {
            listener.onError(session, error);
        }
    }
}

