/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.listener;

import java.io.IOException;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.listener.EventListener;
import org.noear.socketd.transport.core.listener.PathMapper;
import org.noear.socketd.transport.core.listener.PathMapperDefault;

public class PathListener
implements Listener {
    protected final PathMapper mapper;

    public PathListener() {
        this.mapper = new PathMapperDefault();
    }

    public PathListener(PathMapper mapper) {
        this.mapper = mapper;
    }

    public PathListener of(String path, Listener listener) {
        this.mapper.put(path, listener);
        return this;
    }

    public EventListener of(String path) {
        EventListener l1 = new EventListener();
        this.mapper.put(path, l1);
        return l1;
    }

    public int size() {
        return this.mapper.size();
    }

    @Override
    public void onOpen(Session session) throws IOException {
        Listener l1 = this.mapper.get(session.path());
        if (l1 != null) {
            l1.onOpen(session);
        }
    }

    @Override
    public void onMessage(Session session, Message message) throws IOException {
        Listener l1 = this.mapper.get(session.path());
        if (l1 != null) {
            l1.onMessage(session, message);
        }
    }

    @Override
    public void onClose(Session session) {
        Listener l1 = this.mapper.get(session.path());
        if (l1 != null) {
            l1.onClose(session);
        }
    }

    @Override
    public void onError(Session session, Throwable error) {
        Listener l1 = this.mapper.get(session.path());
        if (l1 != null) {
            l1.onError(session, error);
        }
    }
}

