/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.listener;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.utils.IoBiConsumer;
import org.noear.socketd.utils.IoConsumer;

public class EventListener
implements Listener {
    private IoConsumer<Session> onOpenHandler;
    private IoBiConsumer<Session, Message> onMessageHandler;
    private Consumer<Session> onCloseHandler;
    private BiConsumer<Session, Throwable> onErrorHandler;
    private Map<String, IoBiConsumer<Session, Message>> onMessageRouting = new ConcurrentHashMap<String, IoBiConsumer<Session, Message>>();

    public EventListener onOpen(IoConsumer<Session> onOpen) {
        this.onOpenHandler = onOpen;
        return this;
    }

    public EventListener onMessage(IoBiConsumer<Session, Message> onMessage) {
        this.onMessageHandler = onMessage;
        return this;
    }

    public EventListener onClose(Consumer<Session> onClose) {
        this.onCloseHandler = onClose;
        return this;
    }

    public EventListener onError(BiConsumer<Session, Throwable> onError) {
        this.onErrorHandler = onError;
        return this;
    }

    public EventListener on(String event, IoBiConsumer<Session, Message> handler) {
        this.onMessageRouting.put(event, handler);
        return this;
    }

    @Override
    public void onOpen(Session session) throws IOException {
        if (this.onOpenHandler != null) {
            this.onOpenHandler.accept(session);
        }
    }

    @Override
    public void onMessage(Session session, Message message) throws IOException {
        IoBiConsumer<Session, Message> messageHandler;
        if (this.onMessageHandler != null) {
            this.onMessageHandler.accept(session, message);
        }
        if ((messageHandler = this.onMessageRouting.get(message.event())) != null) {
            messageHandler.accept(session, message);
        }
    }

    @Override
    public void onClose(Session session) {
        if (this.onCloseHandler != null) {
            this.onCloseHandler.accept(session);
        }
    }

    @Override
    public void onError(Session session, Throwable error) {
        if (this.onErrorHandler != null) {
            this.onErrorHandler.accept(session, error);
        }
    }
}

