/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.internal;

import java.io.IOException;
import org.noear.socketd.exception.SocketdAlarmException;
import org.noear.socketd.exception.SocketdConnectionException;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Processor;
import org.noear.socketd.transport.core.internal.HandshakeDefault;
import org.noear.socketd.transport.core.listener.SimpleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorDefault
implements Processor {
    private static Logger log = LoggerFactory.getLogger(ProcessorDefault.class);
    private Listener listener = new SimpleListener();

    @Override
    public void setListener(Listener listener) {
        if (listener != null) {
            this.listener = listener;
        }
    }

    @Override
    public void onReceive(Channel channel, Frame frame) throws IOException {
        if (log.isDebugEnabled()) {
            if (channel.getConfig().clientMode()) {
                log.debug("C-REV:{}", (Object)frame);
            } else {
                log.debug("S-REV:{}", (Object)frame);
            }
        }
        if (frame.getFlag() == 10) {
            HandshakeDefault handshake = new HandshakeDefault(frame.getMessage());
            channel.setHandshake(handshake);
            this.onOpen(channel);
            if (channel.isValid()) {
                channel.sendConnack(frame.getMessage());
            }
        } else if (frame.getFlag() == 11) {
            HandshakeDefault handshake = new HandshakeDefault(frame.getMessage());
            channel.setHandshake(handshake);
            this.onOpen(channel);
        } else {
            if (channel.getHandshake() == null) {
                channel.close(1);
                if (frame.getFlag() == 30) {
                    throw new SocketdConnectionException("Connection request was rejected");
                }
                if (log.isWarnEnabled()) {
                    log.warn("{} channel handshake is null, sessionId={}", (Object)channel.getConfig().getRoleName(), (Object)channel.getSession().sessionId());
                }
                return;
            }
            try {
                switch (frame.getFlag()) {
                    case 20: {
                        channel.sendPong();
                        break;
                    }
                    case 21: {
                        break;
                    }
                    case 30: {
                        channel.close(1);
                        this.onCloseInternal(channel);
                        break;
                    }
                    case 31: {
                        channel.getConfig().getStreamManger().removeAcceptor(frame.getMessage().sid());
                        this.onError(channel, new SocketdAlarmException(frame.getMessage()));
                        break;
                    }
                    case 40: 
                    case 41: 
                    case 42: {
                        this.onReceiveDo(channel, frame, false);
                        break;
                    }
                    case 48: 
                    case 49: {
                        this.onReceiveDo(channel, frame, true);
                        break;
                    }
                    default: {
                        channel.close(2);
                        this.onCloseInternal(channel);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                this.onError(channel, e);
            }
        }
    }

    private void onReceiveDo(Channel channel, Frame frame, boolean isReply) throws IOException {
        String fragmentIdxStr;
        if (channel.getConfig().getFragmentHandler().aggrEnable() && (fragmentIdxStr = frame.getMessage().meta("Data-Fragment-Idx")) != null) {
            int index = Integer.parseInt(fragmentIdxStr);
            Frame frameNew = channel.getConfig().getFragmentHandler().aggrFragment(channel, index, frame.getMessage());
            if (frameNew == null) {
                return;
            }
            frame = frameNew;
        }
        if (isReply) {
            channel.retrieve(frame);
        } else {
            this.onMessage(channel, frame.getMessage());
        }
    }

    @Override
    public void onOpen(Channel channel) throws IOException {
        this.listener.onOpen(channel.getSession());
    }

    @Override
    public void onMessage(Channel channel, Message message) throws IOException {
        channel.getConfig().getChannelExecutor().submit(() -> {
            block2: {
                try {
                    this.listener.onMessage(channel.getSession(), message);
                }
                catch (Throwable e) {
                    if (!log.isWarnEnabled()) break block2;
                    log.warn("{} channel listener onMessage error", (Object)channel.getConfig().getRoleName(), (Object)e);
                }
            }
        });
    }

    @Override
    public void onClose(Channel channel) {
        if (channel.isClosed() == 0) {
            this.onCloseInternal(channel);
        }
    }

    private void onCloseInternal(Channel channel) {
        this.listener.onClose(channel.getSession());
    }

    @Override
    public void onError(Channel channel, Throwable error) {
        this.listener.onError(channel.getSession(), error);
    }
}

