/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.internal;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.socketd.transport.core.HandshakeInternal;
import org.noear.socketd.transport.core.MessageInternal;
import org.noear.socketd.utils.Utils;

public class HandshakeDefault
implements HandshakeInternal {
    private final MessageInternal source;
    private final URI uri;
    private final String version;
    private final Map<String, String> paramMap;

    @Override
    public MessageInternal getSource() {
        return this.source;
    }

    public HandshakeDefault(MessageInternal source) {
        this.source = source;
        this.uri = URI.create(source.event());
        this.version = source.meta("SocketD");
        this.paramMap = new ConcurrentHashMap<String, String>();
        String queryString = this.uri.getQuery();
        if (Utils.isNotEmpty(queryString)) {
            for (String kvStr : queryString.split("&")) {
                int idx = kvStr.indexOf(61);
                if (idx <= 0) continue;
                this.paramMap.put(kvStr.substring(0, idx), kvStr.substring(idx + 1));
            }
        }
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public Map<String, String> paramMap() {
        return this.paramMap;
    }

    @Override
    public String param(String name) {
        return this.paramMap.get(name);
    }

    @Override
    public String paramOrDefault(String name, String def) {
        return this.paramMap.getOrDefault(name, def);
    }

    @Override
    public void param(String name, String value) {
        this.paramMap.put(name, value);
    }
}

