/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.noear.socketd.transport.core.Asserts;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelBase;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.MessageInternal;
import org.noear.socketd.transport.core.Processor;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.StreamAcceptor;
import org.noear.socketd.transport.core.StreamAcceptorBase;
import org.noear.socketd.transport.core.StreamManger;
import org.noear.socketd.transport.core.internal.MessageDefault;
import org.noear.socketd.transport.core.internal.SessionDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelDefault<S>
extends ChannelBase
implements ChannelInternal {
    private static Logger log = LoggerFactory.getLogger(ChannelDefault.class);
    private final S source;
    private final Processor processor;
    private final ChannelAssistant<S> assistant;
    private final StreamManger acceptorManger;
    private Session session;
    private Object SEND_LOCK = new Object();

    public ChannelDefault(S source, ChannelSupporter<S> supporter) {
        super(supporter.config());
        this.source = source;
        this.processor = supporter.processor();
        this.assistant = supporter.assistant();
        this.acceptorManger = supporter.config().getStreamManger();
    }

    @Override
    public boolean isValid() {
        return this.isClosed() == 0 && this.assistant.isValid(this.source);
    }

    @Override
    public InetSocketAddress getRemoteAddress() throws IOException {
        return this.assistant.getRemoteAddress(this.source);
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        return this.assistant.getLocalAddress(this.source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Frame frame, StreamAcceptorBase acceptor) throws IOException {
        Asserts.assertClosed(this);
        if (log.isDebugEnabled()) {
            if (this.getConfig().clientMode()) {
                log.debug("C-SEN:{}", (Object)frame);
            } else {
                log.debug("S-SEN:{}", (Object)frame);
            }
        }
        Object object = this.SEND_LOCK;
        synchronized (object) {
            if (frame.getMessage() != null) {
                MessageInternal message = frame.getMessage();
                if (acceptor != null) {
                    this.acceptorManger.addAcceptor(message.sid(), acceptor);
                }
                if (message.entity() != null) {
                    if (message.dataSize() > this.getConfig().getFragmentSize()) {
                        Entity fragmentEntity;
                        message.metaMap().put("Data-Length", String.valueOf(message.dataSize()));
                        int fragmentIndex = 0;
                        while ((fragmentEntity = this.getConfig().getFragmentHandler().nextFragment(this, ++fragmentIndex, message)) != null) {
                            Frame fragmentFrame = new Frame(frame.getFlag(), new MessageDefault().flag(frame.getFlag()).sid(message.sid()).entity(fragmentEntity));
                            this.assistant.write(this.source, fragmentFrame);
                        }
                        return;
                    }
                    this.assistant.write(this.source, frame);
                    return;
                }
            }
            this.assistant.write(this.source, frame);
        }
    }

    @Override
    public void retrieve(Frame frame) {
        StreamAcceptor acceptor = this.acceptorManger.getAcceptor(frame.getMessage().sid());
        if (acceptor != null) {
            if (acceptor.isSingle() || frame.getFlag() == 49) {
                this.acceptorManger.removeAcceptor(frame.getMessage().sid());
            }
            if (acceptor.isSingle()) {
                acceptor.accept(frame.getMessage(), this);
            } else {
                this.getConfig().getChannelExecutor().submit(() -> acceptor.accept(frame.getMessage(), this));
            }
        } else if (log.isDebugEnabled()) {
            log.debug("{} acceptor not found, sid={}, sessionId={}", new Object[]{this.getConfig().getRoleName(), frame.getMessage().sid(), this.getSession().sessionId()});
        }
    }

    @Override
    public void reconnect() throws IOException {
    }

    @Override
    public void onError(Throwable error) {
        this.processor.onError(this, error);
    }

    @Override
    public Session getSession() {
        if (this.session == null) {
            this.session = new SessionDefault(this);
        }
        return this.session;
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public void close(int code) {
        block3: {
            if (log.isDebugEnabled()) {
                log.debug("{} channel will be closed, sessionId={}", (Object)this.getConfig().getRoleName(), (Object)this.getSession().sessionId());
            }
            super.close(code);
            try {
                this.assistant.close(this.source);
            }
            catch (IOException e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn("{} channel close error, sessionId={}", new Object[]{this.getConfig().getRoleName(), this.getSession().sessionId(), e});
            }
        }
    }
}

