/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.fragment;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.FragmentHandler;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.MessageInternal;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.fragment.FragmentAggregatorDefault;

public class FragmentHandlerDefault
implements FragmentHandler {
    @Override
    public Entity nextFragment(Channel channel, int fragmentIndex, MessageInternal message) throws IOException {
        ByteBuffer dataBuffer = this.readFragmentData(message.data(), channel.getConfig().getFragmentSize());
        if (dataBuffer.limit() == 0) {
            return null;
        }
        EntityDefault fragmentEntity = new EntityDefault().data(dataBuffer);
        if (fragmentIndex == 1) {
            fragmentEntity.metaMap(message.metaMap());
        }
        fragmentEntity.meta("Data-Fragment-Idx", String.valueOf(fragmentIndex));
        return fragmentEntity;
    }

    @Override
    public Frame aggrFragment(Channel channel, int index, MessageInternal message) throws IOException {
        FragmentAggregatorDefault aggregator = (FragmentAggregatorDefault)channel.getAttachment(message.sid());
        if (aggregator == null) {
            aggregator = new FragmentAggregatorDefault(message);
            channel.setAttachment(aggregator.getSid(), aggregator);
        }
        aggregator.add(index, message);
        if (aggregator.getDataLength() > aggregator.getDataStreamSize()) {
            return null;
        }
        channel.setAttachment(message.sid(), null);
        return aggregator.get();
    }

    @Override
    public boolean aggrEnable() {
        return true;
    }

    private ByteBuffer readFragmentData(ByteBuffer ins, int maxSize) {
        int size = 0;
        size = ins.remaining() > maxSize ? maxSize : ins.remaining();
        byte[] bytes = new byte[size];
        ins.get(bytes);
        return ByteBuffer.wrap(bytes);
    }
}

