/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.fragment;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.noear.socketd.exception.SocketdCodecException;
import org.noear.socketd.transport.core.FragmentAggregator;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.MessageInternal;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.fragment.FragmentHolder;
import org.noear.socketd.transport.core.internal.MessageDefault;
import org.noear.socketd.utils.Utils;

public class FragmentAggregatorDefault
implements FragmentAggregator {
    private MessageInternal main;
    private List<FragmentHolder> fragmentHolders = new ArrayList<FragmentHolder>();
    private int dataStreamSize;
    private int dataLength;

    public FragmentAggregatorDefault(MessageInternal main) {
        this.main = main;
        String dataLengthStr = main.meta("Data-Length");
        if (Utils.isEmpty(dataLengthStr)) {
            throw new SocketdCodecException("Missing 'Data-Length' meta, event=" + main.event());
        }
        this.dataLength = Integer.parseInt(dataLengthStr);
    }

    @Override
    public String getSid() {
        return this.main.sid();
    }

    @Override
    public int getDataStreamSize() {
        return this.dataStreamSize;
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    public void add(int index, MessageInternal message) throws IOException {
        this.fragmentHolders.add(new FragmentHolder(index, message));
        this.dataStreamSize += message.dataSize();
    }

    @Override
    public Frame get() throws IOException {
        this.fragmentHolders.sort(Comparator.comparing(fh -> fh.getIndex()));
        ByteBuffer dataBuffer = ByteBuffer.allocate(this.dataLength);
        for (FragmentHolder fh2 : this.fragmentHolders) {
            dataBuffer.put(fh2.getMessage().data().array());
        }
        dataBuffer.flip();
        return new Frame(this.main.flag(), new MessageDefault().flag(this.main.flag()).sid(this.main.sid()).event(this.main.event()).entity(new EntityDefault().metaMap(this.main.metaMap()).data(dataBuffer)));
    }
}

