/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.entity;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.socketd.transport.core.Constants;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.utils.Utils;

public class EntityDefault
implements Entity {
    private Map<String, String> metaMap;
    private String metaString = "";
    private boolean metaStringChanged = false;
    private ByteBuffer data = Constants.DEF_DATA;
    private int dataSize = 0;
    private String dataAsString;

    public EntityDefault at(String name) {
        this.meta("@", name);
        return this;
    }

    public EntityDefault metaString(String metaString) {
        this.metaMap = null;
        this.metaString = metaString;
        this.metaStringChanged = false;
        return this;
    }

    @Override
    public String metaString() {
        if (this.metaStringChanged) {
            StringBuilder buf = new StringBuilder();
            ArrayList<String> metaKeys = new ArrayList<String>(this.metaMap().keySet());
            for (String name : metaKeys) {
                String val = this.metaMap().get(name);
                buf.append(name).append("=").append(val).append("&");
            }
            if (buf.length() > 0) {
                buf.setLength(buf.length() - 1);
            }
            this.metaString = buf.toString();
            this.metaStringChanged = false;
        }
        return this.metaString;
    }

    public EntityDefault metaMap(Map<String, String> metaMap) {
        this.metaMap().putAll(metaMap);
        this.metaString = null;
        this.metaStringChanged = true;
        return this;
    }

    @Override
    public Map<String, String> metaMap() {
        if (this.metaMap == null) {
            this.metaMap = new ConcurrentHashMap<String, String>();
            this.metaStringChanged = false;
            if (Utils.isNotEmpty(this.metaString)) {
                for (String kvStr : this.metaString.split("&")) {
                    int idx = kvStr.indexOf(61);
                    if (idx <= 0) continue;
                    this.metaMap.put(kvStr.substring(0, idx), kvStr.substring(idx + 1));
                }
            }
        }
        return this.metaMap;
    }

    public EntityDefault meta(String name, String val) {
        this.metaMap().put(name, val);
        this.metaStringChanged = true;
        return this;
    }

    @Override
    public String meta(String name) {
        return this.metaMap().get(name);
    }

    @Override
    public String metaOrDefault(String name, String def) {
        return this.metaMap().getOrDefault(name, def);
    }

    public EntityDefault data(byte[] data) {
        this.data = ByteBuffer.wrap(data);
        this.dataSize = data.length;
        return this;
    }

    public EntityDefault data(ByteBuffer data) {
        this.data = data;
        this.dataSize = data.limit();
        return this;
    }

    @Override
    public ByteBuffer data() {
        return this.data;
    }

    @Override
    public String dataAsString() {
        if (this.dataAsString == null) {
            this.dataAsString = new String(this.dataAsBytes(), StandardCharsets.UTF_8);
        }
        return this.dataAsString;
    }

    @Override
    public byte[] dataAsBytes() {
        if (this.data instanceof MappedByteBuffer) {
            byte[] tmp = new byte[this.dataSize];
            this.data.mark();
            this.data.get(tmp);
            this.data.reset();
            return tmp;
        }
        return this.data.array();
    }

    @Override
    public int dataSize() {
        return this.dataSize;
    }

    @Override
    public void release() {
    }

    public String toString() {
        return "Entity{meta='" + this.metaString() + '\'' + ", data=byte[" + this.dataSize + ']' + '}';
    }
}

