/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.noear.socketd.transport.core.Asserts;
import org.noear.socketd.transport.core.Codec;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Flags;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.buffer.BufferReader;
import org.noear.socketd.transport.core.buffer.BufferWriter;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.internal.MessageDefault;

public class CodecByteBuffer
implements Codec<BufferReader, BufferWriter> {
    private final Config config;

    public CodecByteBuffer(Config config) {
        this.config = config;
    }

    @Override
    public <T extends BufferWriter> T write(Frame frame, Function<Integer, T> factory) throws IOException {
        if (frame.getMessage() == null) {
            int frameSize = 8;
            BufferWriter target = (BufferWriter)factory.apply(frameSize);
            target.putInt(frameSize);
            target.putInt(frame.getFlag());
            target.flush();
            return (T)target;
        }
        byte[] sidB = frame.getMessage().sid().getBytes(this.config.getCharset());
        byte[] eventB = frame.getMessage().event().getBytes(this.config.getCharset());
        byte[] metaStringB = frame.getMessage().metaString().getBytes(this.config.getCharset());
        int frameSize = 8 + sidB.length + eventB.length + metaStringB.length + frame.getMessage().dataSize() + 6;
        Asserts.assertSize("sid", sidB.length, 64);
        Asserts.assertSize("event", eventB.length, 512);
        Asserts.assertSize("metaString", metaStringB.length, 4096);
        Asserts.assertSize("data", frame.getMessage().dataSize(), 0x1000000);
        BufferWriter target = (BufferWriter)factory.apply(frameSize);
        target.putInt(frameSize);
        target.putInt(frame.getFlag());
        target.putBytes(sidB);
        target.putChar(10);
        target.putBytes(eventB);
        target.putChar(10);
        target.putBytes(metaStringB);
        target.putChar(10);
        target.putBytes(frame.getMessage().dataAsBytes());
        target.flush();
        return (T)target;
    }

    @Override
    public Frame read(BufferReader buffer) {
        byte[] data;
        int frameSize = buffer.getInt();
        if (frameSize > buffer.remaining() + 4) {
            return null;
        }
        int flag = buffer.getInt();
        if (frameSize == 8) {
            return new Frame(Flags.of(flag), null);
        }
        int metaBufSize = Math.min(4096, buffer.remaining());
        ByteBuffer sb = ByteBuffer.allocate(metaBufSize);
        String sid = this.decodeString(buffer, sb, 64);
        String event = this.decodeString(buffer, sb, 512);
        String metaString = this.decodeString(buffer, sb, 4096);
        int dataRealSize = frameSize - buffer.position();
        if (dataRealSize > 0x1000000) {
            data = new byte[0x1000000];
            buffer.get(data, 0, 0x1000000);
            for (int i = dataRealSize - 0x1000000; i > 0; --i) {
                buffer.get();
            }
        } else {
            data = new byte[dataRealSize];
            if (dataRealSize > 0) {
                buffer.get(data, 0, dataRealSize);
            }
        }
        MessageDefault message = new MessageDefault().flag(Flags.of(flag)).sid(sid).event(event).entity(new EntityDefault().data(data).metaString(metaString));
        return new Frame(message.flag(), message);
    }

    protected String decodeString(BufferReader reader, ByteBuffer buf, int maxLen) {
        byte c;
        buf.clear();
        while ((c = reader.get()) != 10) {
            if (maxLen > 0 && maxLen <= buf.position() || c == 0) continue;
            buf.put(c);
        }
        buf.flip();
        if (buf.limit() < 1) {
            return "";
        }
        return new String(buf.array(), 0, buf.limit(), this.config.getCharset());
    }
}

