/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core;

import org.noear.socketd.exception.SocketdChannelException;
import org.noear.socketd.exception.SocketdSizeLimitException;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.utils.Utils;

public class Asserts {
    public static void assertClosed(Channel channel) {
        if (channel != null && channel.isClosed() > 0) {
            throw new SocketdChannelException("This channel is closed, sessionId=" + channel.getSession().sessionId());
        }
    }

    public static void assertClosedByUser(Channel channel) {
        if (channel != null && channel.isClosed() == 4) {
            throw new SocketdChannelException("This channel is closed, sessionId=" + channel.getSession().sessionId());
        }
    }

    public static void assertNull(String name, Object val) {
        if (val == null) {
            throw new IllegalArgumentException("The argument cannot be null: " + name);
        }
    }

    public static void assertEmpty(String name, String val) {
        if (Utils.isEmpty(val)) {
            throw new IllegalArgumentException("The argument cannot be empty: " + name);
        }
    }

    public static void assertSize(String name, int size, int limitSize) {
        if (size > limitSize) {
            StringBuilder buf = new StringBuilder();
            buf.append("This message ").append(name).append(" size is out of limit ").append(limitSize).append(" (").append(size).append(")");
            throw new SocketdSizeLimitException(buf.toString());
        }
    }
}

