/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ScheduledFuture;
import org.noear.socketd.exception.SocketdChannelException;
import org.noear.socketd.exception.SocketdException;
import org.noear.socketd.transport.client.ClientConnector;
import org.noear.socketd.transport.core.Asserts;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.ChannelBase;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.HeartbeatHandler;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.StreamAcceptorBase;
import org.noear.socketd.transport.core.internal.HeartbeatHandlerDefault;
import org.noear.socketd.utils.RunUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientChannel
extends ChannelBase
implements Channel {
    private static final Logger log = LoggerFactory.getLogger(ClientChannel.class);
    private final ClientConnector connector;
    private Channel real;
    private HeartbeatHandler heartbeatHandler;
    private ScheduledFuture<?> heartbeatScheduledFuture;

    public ClientChannel(Channel real, ClientConnector connector) {
        super(real.getConfig());
        this.connector = connector;
        this.real = real;
        this.heartbeatHandler = connector.heartbeatHandler();
        if (this.heartbeatHandler == null) {
            this.heartbeatHandler = new HeartbeatHandlerDefault();
        }
        this.initHeartbeat();
    }

    private void initHeartbeat() {
        if (this.heartbeatScheduledFuture != null) {
            this.heartbeatScheduledFuture.cancel(false);
        }
        if (this.connector.autoReconnect()) {
            this.heartbeatScheduledFuture = RunUtils.delayAndRepeat(() -> {
                block2: {
                    try {
                        this.heartbeatHandle();
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block2;
                        log.warn("Client channel heartbeat error", (Throwable)e);
                    }
                }
            }, this.connector.heartbeatInterval());
        }
    }

    @Override
    public boolean isValid() {
        if (this.real == null) {
            return false;
        }
        return this.real.isValid();
    }

    @Override
    public int isClosed() {
        if (this.real == null) {
            return 0;
        }
        return this.real.isClosed();
    }

    @Override
    public InetSocketAddress getRemoteAddress() throws IOException {
        if (this.real == null) {
            return null;
        }
        return this.real.getRemoteAddress();
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        if (this.real == null) {
            return null;
        }
        return this.real.getLocalAddress();
    }

    private void heartbeatHandle() throws IOException {
        if (this.real != null) {
            if (this.real.getHandshake() == null) {
                return;
            }
            if (this.real.isClosed() == 4) {
                if (log.isDebugEnabled()) {
                    log.debug("Client channel is closed (pause heartbeat), sessionId={}", (Object)this.getSession().sessionId());
                }
                return;
            }
        }
        try {
            this.prepareCheck();
            this.heartbeatHandler.heartbeat(this.getSession());
        }
        catch (SocketdException e) {
            throw e;
        }
        catch (Throwable e) {
            if (this.connector.autoReconnect()) {
                this.real.close(3);
                this.real = null;
            }
            throw new SocketdChannelException(e);
        }
    }

    @Override
    public void send(Frame frame, StreamAcceptorBase acceptor) throws IOException {
        Asserts.assertClosedByUser(this.real);
        try {
            this.prepareCheck();
            this.real.send(frame, acceptor);
        }
        catch (SocketdException e) {
            throw e;
        }
        catch (Throwable e) {
            if (this.connector.autoReconnect()) {
                this.real.close(3);
                this.real = null;
            }
            throw new SocketdChannelException(e);
        }
    }

    @Override
    public void retrieve(Frame frame) {
        this.real.retrieve(frame);
    }

    @Override
    public Session getSession() {
        return this.real.getSession();
    }

    @Override
    public void reconnect() throws IOException {
        this.initHeartbeat();
        this.prepareCheck();
    }

    @Override
    public void onError(Throwable error) {
        this.real.onError(error);
    }

    @Override
    public void close(int code) {
        RunUtils.runAndTry(() -> this.heartbeatScheduledFuture.cancel(true));
        RunUtils.runAndTry(() -> this.connector.close());
        RunUtils.runAndTry(() -> this.real.close(code));
    }

    private boolean prepareCheck() throws IOException {
        if (this.real == null || !this.real.isValid()) {
            this.real = this.connector.connect();
            return true;
        }
        return false;
    }
}

