/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.client;

import java.io.IOException;
import org.noear.socketd.transport.client.Client;
import org.noear.socketd.transport.client.ClientChannel;
import org.noear.socketd.transport.client.ClientConfig;
import org.noear.socketd.transport.client.ClientConfigHandler;
import org.noear.socketd.transport.client.ClientConnector;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.HeartbeatHandler;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Processor;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.internal.ProcessorDefault;
import org.noear.socketd.transport.core.internal.SessionDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientBase<T extends ChannelAssistant>
implements Client {
    private static final Logger log = LoggerFactory.getLogger(ClientBase.class);
    protected Processor processor = new ProcessorDefault();
    protected HeartbeatHandler heartbeatHandler;
    private final ClientConfig config;
    private final T assistant;

    public ClientBase(ClientConfig clientConfig, T assistant) {
        this.config = clientConfig;
        this.assistant = assistant;
    }

    public T assistant() {
        return this.assistant;
    }

    public HeartbeatHandler heartbeatHandler() {
        return this.heartbeatHandler;
    }

    public long heartbeatInterval() {
        return this.config.getHeartbeatInterval();
    }

    public ClientConfig config() {
        return this.config;
    }

    public Processor processor() {
        return this.processor;
    }

    @Override
    public Client heartbeatHandler(HeartbeatHandler handler) {
        if (handler != null) {
            this.heartbeatHandler = handler;
        }
        return this;
    }

    @Override
    public Client config(ClientConfigHandler configHandler) {
        if (configHandler != null) {
            configHandler.clientConfig(this.config);
        }
        return this;
    }

    @Override
    public Client listen(Listener listener) {
        if (listener != null) {
            this.processor.setListener(listener);
        }
        return this;
    }

    @Override
    public Session open() throws IOException {
        ClientConnector connector = this.createConnector();
        ChannelInternal channel0 = connector.connect();
        ClientChannel clientChannel = new ClientChannel(channel0, connector);
        clientChannel.setHandshake(channel0.getHandshake());
        SessionDefault session = new SessionDefault(clientChannel);
        channel0.setSession(session);
        log.info("Socket.D client successfully connected: {link={}}", (Object)this.config().getLinkUrl());
        return session;
    }

    protected abstract ClientConnector createConnector();
}

