/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.noear.snack.ONodeData;
import org.noear.snack.ONodeType;
import org.noear.snack.OValue;
import org.noear.snack.core.Context;
import org.noear.snack.core.DEFAULTS;
import org.noear.snack.core.Feature;
import org.noear.snack.core.Handler;
import org.noear.snack.core.JsonPath;
import org.noear.snack.core.Options;
import org.noear.snack.from.Fromer;
import org.noear.snack.to.Toer;

public class ONode {
    protected Options _o;
    protected ONodeData _d;

    public static String version() {
        return "3.2";
    }

    public ONode() {
        this._o = Options.def();
        this._d = new ONodeData(this);
    }

    public ONode(Options options) {
        this._d = new ONodeData(this);
        this._o = options == null ? Options.def() : options;
    }

    public static ONode newValue() {
        return new ONode().asValue();
    }

    public static ONode newObject() {
        return new ONode().asObject();
    }

    public static ONode newArray() {
        return new ONode().asArray();
    }

    public ONode select(String jpath, boolean useStandard, boolean cacheJpath) {
        return JsonPath.eval(this, jpath, useStandard, cacheJpath);
    }

    public ONode select(String jpath, boolean useStandard) {
        return this.select(jpath, useStandard, true);
    }

    public ONode select(String jpath) {
        return this.select(jpath, false);
    }

    public boolean exists(String jpath) {
        return !this.select(jpath).isUndefined();
    }

    public ONode asObject() {
        this._d.tryInitObject();
        return this;
    }

    public ONode asArray() {
        this._d.tryInitArray();
        return this;
    }

    public ONode asValue() {
        this._d.tryInitValue();
        return this;
    }

    public ONode asNull() {
        this._d.tryInitNull();
        return this;
    }

    public ONodeData nodeData() {
        return this._d;
    }

    public ONodeType nodeType() {
        return this._d.nodeType;
    }

    public ONode options(Options opts) {
        if (opts != null) {
            this._o = opts;
        }
        return this;
    }

    public ONode options(Consumer<Options> custom) {
        custom.accept(this._o);
        return this;
    }

    public Options options() {
        return this._o;
    }

    public ONode build(Consumer<ONode> custom) {
        custom.accept(this);
        return this;
    }

    public OValue val() {
        return this.asValue()._d.value;
    }

    public ONode val(Object val) {
        if (val == null) {
            this._d.tryInitNull();
        } else if (val instanceof ONode) {
            this._d.tryInitNull();
            this._d = ((ONode)val)._d;
        } else if (val instanceof Map || val instanceof Collection) {
            this._d.tryInitNull();
            this._d = this.buildVal((Object)val)._d;
        } else {
            this._d.tryInitValue();
            this._d.value.set(val);
        }
        return this;
    }

    public String getString() {
        if (this.isValue()) {
            return this._d.value.getString();
        }
        if (this.isArray()) {
            return this.toJson();
        }
        if (this.isObject()) {
            return this.toJson();
        }
        if (this._o.hasFeature(Feature.StringNullAsEmpty)) {
            return "";
        }
        return null;
    }

    public short getShort() {
        if (this.isValue()) {
            return this._d.value.getShort();
        }
        return 0;
    }

    public int getInt() {
        if (this.isValue()) {
            return this._d.value.getInt();
        }
        return 0;
    }

    public long getLong() {
        if (this.isValue()) {
            return this._d.value.getLong();
        }
        return 0L;
    }

    public float getFloat() {
        if (this.isValue()) {
            return this._d.value.getFloat();
        }
        return 0.0f;
    }

    public double getDouble() {
        if (this.isValue()) {
            return this._d.value.getDouble();
        }
        return 0.0;
    }

    public double getDouble(int scale) {
        double temp = this.getDouble();
        if (temp == 0.0) {
            return 0.0;
        }
        return new BigDecimal(temp).setScale(scale, 4).doubleValue();
    }

    public boolean getBoolean() {
        if (this.isValue()) {
            return this._d.value.getBoolean();
        }
        return false;
    }

    public Date getDate() {
        if (this.isValue()) {
            return this._d.value.getDate();
        }
        return null;
    }

    public char getChar() {
        if (this.isValue()) {
            return this._d.value.getChar();
        }
        return '\u0000';
    }

    public String getRawString() {
        if (this.isValue()) {
            return this._d.value.getRawString();
        }
        return null;
    }

    public Number getRawNumber() {
        if (this.isValue()) {
            return this._d.value.getRawNumber();
        }
        return null;
    }

    public Boolean getRawBoolean() {
        if (this.isValue()) {
            return this._d.value.getRawBoolean();
        }
        return null;
    }

    public Date getRawDate() {
        if (this.isValue()) {
            return this._d.value.getRawDate();
        }
        return null;
    }

    public void clear() {
        if (this.isObject()) {
            this._d.object.clear();
        } else if (this.isArray()) {
            this._d.array.clear();
        }
    }

    public int count() {
        if (this.isObject()) {
            return this._d.object.size();
        }
        if (this.isArray()) {
            return this._d.array.size();
        }
        return 0;
    }

    public Map<String, ONode> obj() {
        return this.asObject()._d.object;
    }

    public boolean contains(String key) {
        if (this.isObject()) {
            return this._d.object.containsKey(key);
        }
        return false;
    }

    public ONode rename(String key, String newKey) {
        if (key == null || newKey == null) {
            return this;
        }
        if (!key.equals(newKey)) {
            if (this.isObject()) {
                ONode.rename_do(this, key, newKey);
            } else if (this.isArray()) {
                for (ONode n : this._d.array) {
                    ONode.rename_do(n, key, newKey);
                }
            }
        }
        return this;
    }

    private static void rename_do(ONode n, String key, String newKey) {
        ONode tmp;
        if (n.isObject() && (tmp = n._d.object.get(key)) != null) {
            n._d.object.put(newKey, tmp);
            n._d.object.remove(key);
        }
    }

    public ONode get(String key) {
        this._d.tryInitObject();
        ONode tmp = this._d.object.get(key);
        if (tmp == null) {
            return new ONode(this._o);
        }
        return tmp;
    }

    public ONode getOrNew(String key) {
        this._d.tryInitObject();
        ONode tmp = this._d.object.get(key);
        if (tmp == null) {
            tmp = new ONode(this._o);
            this._d.object.put(key, tmp);
        }
        return tmp;
    }

    public ONode getOrNull(String key) {
        if (this.isObject()) {
            return this._d.object.get(key);
        }
        return null;
    }

    public ONode getNew(String key) {
        ONode tmp = new ONode(this._o);
        this._d.object.put(key, tmp);
        return tmp;
    }

    private ONode buildVal(Object val) {
        if (val instanceof Map) {
            return new ONode(this._o).setAll((Map)val);
        }
        if (val instanceof Collection) {
            return new ONode(this._o).addAll((Collection)val);
        }
        if (val != null && val.getClass().isArray()) {
            return new ONode(this._o).addAll(Arrays.asList((Object[])val));
        }
        return new ONode(this._o).val(val);
    }

    public ONode set(String key, Object val) {
        this._d.tryInitObject();
        if (val instanceof ONode) {
            this._d.object.put(key, (ONode)val);
        } else {
            this._d.object.put(key, this.buildVal(val));
        }
        return this;
    }

    public ONode setNode(String key, ONode val) {
        this._d.object.put(key, val);
        return this;
    }

    public ONode setAll(ONode obj) {
        this._d.tryInitObject();
        if (obj != null && obj.isObject()) {
            this._d.object.putAll(obj._d.object);
        }
        return this;
    }

    public <T> ONode setAll(Map<String, T> map) {
        this._d.tryInitObject();
        if (map != null) {
            map.forEach(this::set);
        }
        return this;
    }

    public <T> ONode setAll(Map<String, T> map, BiConsumer<ONode, T> handler) {
        this._d.tryInitObject();
        if (map != null) {
            map.forEach((? super K k, ? super V v) -> handler.accept(this.get((String)k), v));
        }
        return this;
    }

    public void remove(String key) {
        if (this.isObject()) {
            this._d.object.remove(key);
        }
    }

    public List<ONode> ary() {
        return this.asArray()._d.array;
    }

    public ONode get(int index) {
        this._d.tryInitArray();
        if (index >= 0 && this._d.array.size() > index) {
            return this._d.array.get(index);
        }
        return new ONode(this._o);
    }

    public ONode getOrNew(int index) {
        this._d.tryInitArray();
        if (this._d.array.size() > index) {
            return this._d.array.get(index);
        }
        ONode n = null;
        for (int i = this._d.array.size(); i <= index; ++i) {
            n = new ONode(this._o);
            this._d.array.add(n);
        }
        return n;
    }

    public ONode getOrNull(int index) {
        if (this.isArray() && index >= 0 && this._d.array.size() > index) {
            return this._d.array.get(index);
        }
        return null;
    }

    public void removeAt(int index) {
        if (this.isArray()) {
            this._d.array.remove(index);
        }
    }

    public ONode addNew() {
        this._d.tryInitArray();
        ONode n = new ONode(this._o);
        this._d.array.add(n);
        return n;
    }

    public ONode add(Object val) {
        this._d.tryInitArray();
        if (val instanceof ONode) {
            this._d.array.add((ONode)val);
        } else {
            this._d.array.add(this.buildVal(val));
        }
        return this;
    }

    public ONode addNode(ONode val) {
        this._d.array.add(val);
        return this;
    }

    public ONode addAll(ONode ary) {
        this._d.tryInitArray();
        if (ary != null && ary.isArray()) {
            this._d.array.addAll(ary._d.array);
        }
        return this;
    }

    public <T> ONode addAll(Collection<T> ary) {
        this._d.tryInitArray();
        if (ary != null) {
            ary.forEach((? super T m) -> this.add(m));
        }
        return this;
    }

    public <T> ONode addAll(Collection<T> ary, BiConsumer<ONode, T> handler) {
        this._d.tryInitArray();
        if (ary != null) {
            ary.forEach((? super T m) -> handler.accept(this.addNew(), m));
        }
        return this;
    }

    public boolean isUndefined() {
        return this._d.nodeType == ONodeType.Null;
    }

    public boolean isNull() {
        return this._d.nodeType == ONodeType.Null || this.isValue() && this._d.value.isNull();
    }

    public boolean isValue() {
        return this._d.nodeType == ONodeType.Value;
    }

    public boolean isObject() {
        return this._d.nodeType == ONodeType.Object;
    }

    public boolean isArray() {
        return this._d.nodeType == ONodeType.Array;
    }

    public ONode forEach(BiConsumer<String, ONode> consumer) {
        if (this.isObject()) {
            this._d.object.forEach(consumer);
        }
        return this;
    }

    public ONode forEach(Consumer<ONode> consumer) {
        if (this.isArray()) {
            this._d.array.forEach(consumer);
        }
        return this;
    }

    public String attrGet(String key) {
        return this._d.attrGet(key);
    }

    public ONode attrSet(String key, String val) {
        this._d.attrSet(key, val);
        return this;
    }

    public ONode attrForeach(BiConsumer<String, String> consumer) {
        if (this._d.attrs != null) {
            this._d.attrs.forEach(consumer);
        }
        return this;
    }

    public String toString() {
        return (String)this.to(DEFAULTS.DEF_STRING_TOER);
    }

    public String toJson() {
        return (String)this.to(DEFAULTS.DEF_JSON_TOER);
    }

    public Object toData() {
        return this.to(DEFAULTS.DEF_OBJECT_TOER);
    }

    public <T> T toObject() {
        return this.toObject((Type)((Object)Object.class));
    }

    public <T> T toObject(Type clz) {
        return this.to(DEFAULTS.DEF_OBJECT_TOER, clz);
    }

    public <T> List<T> toObjectList(Class<T> clz) {
        ArrayList<T> list = new ArrayList<T>();
        for (ONode n : this.ary()) {
            list.add(n.toObject(clz));
        }
        return list;
    }

    @Deprecated
    public <T> List<T> toArray(Class<T> clz) {
        return this.toObjectList(clz);
    }

    public <T> T to(Toer toer, Type clz) {
        return (T)new Context((Options)this._o, (ONode)this, (Type)clz).handle((Handler)toer).target;
    }

    public <T> T to(Toer toer) {
        return this.to(toer, null);
    }

    public <T> T bindTo(T target) {
        Context ctx = new Context(this._o, this, target.getClass());
        ctx.target = target;
        return (T)ctx.handle((Handler)DEFAULTS.DEF_OBJECT_TOER).target;
    }

    public ONode fill(Object source) {
        this.val(ONode.doLoad(source, source instanceof String, this._o, null));
        return this;
    }

    public ONode fill(Object source, Feature ... features) {
        this.val(ONode.doLoad(source, source instanceof String, Options.def().add(features), null));
        return this;
    }

    public ONode fillObj(Object source, Feature ... features) {
        this.val(ONode.doLoad(source, false, Options.def().add(features), null));
        return this;
    }

    public ONode fillStr(String source, Feature ... features) {
        this.val(ONode.doLoad(source, true, Options.def().add(features), null));
        return this;
    }

    public static ONode load(Object source) {
        return ONode.load(source, null, null);
    }

    public static ONode load(Object source, Feature ... features) {
        return ONode.load(source, Options.def().add(features), null);
    }

    public static ONode load(Object source, Options opts) {
        return ONode.load(source, opts, null);
    }

    public static ONode load(Object source, Options opts, Fromer fromer) {
        return ONode.doLoad(source, source instanceof String, opts, fromer);
    }

    public static ONode loadStr(String source) {
        return ONode.doLoad(source, true, null, null);
    }

    public static ONode loadStr(String source, Options opts) {
        return ONode.doLoad(source, true, opts, null);
    }

    public static ONode loadStr(String source, Feature ... features) {
        return ONode.doLoad(source, true, Options.def().add(features), null);
    }

    public static ONode loadObj(Object source) {
        return ONode.doLoad(source, false, null, null);
    }

    public static ONode loadObj(Object source, Options opts) {
        return ONode.doLoad(source, false, opts, null);
    }

    public static ONode loadObj(Object source, Feature ... features) {
        return ONode.doLoad(source, false, Options.def().add(features), null);
    }

    private static ONode doLoad(Object source, boolean isString, Options opts, Fromer fromer) {
        if (fromer == null) {
            fromer = isString ? DEFAULTS.DEF_STRING_FROMER : DEFAULTS.DEF_OBJECT_FROMER;
        }
        if (opts == null) {
            opts = Options.def();
        }
        return (ONode)new Context((Options)opts, (Object)source).handle((Handler)fromer).target;
    }

    public static String stringify(Object source) {
        return ONode.stringify(source, Options.def());
    }

    @Deprecated
    public static String stringify(Object source, Feature ... features) {
        if (features.length > 0) {
            return ONode.stringify(source, new Options(Feature.of(features)));
        }
        return ONode.stringify(source, Options.def());
    }

    public static String stringify(Object source, Options opts) {
        return ONode.load(source, opts, DEFAULTS.DEF_OBJECT_FROMER).toString();
    }

    public static String serialize(Object source) {
        return ONode.load(source, Options.serialize(), DEFAULTS.DEF_OBJECT_FROMER).toJson();
    }

    public static <T> T deserialize(String source) {
        return ONode.deserialize(source, Object.class);
    }

    public static <T> T deserialize(String source, Type clz) {
        return ONode.load((Object)source, Options.serialize(), null).toObject(clz);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return this.isNull();
        }
        if (this.isArray()) {
            if (o instanceof ONode) {
                return Objects.equals(this.ary(), ((ONode)o).ary());
            }
            return Objects.equals(this.ary(), o);
        }
        if (this.isObject()) {
            if (o instanceof ONode) {
                return Objects.equals(this.obj(), ((ONode)o).obj());
            }
            return Objects.equals(this.obj(), o);
        }
        if (this.isValue()) {
            if (o instanceof ONode) {
                return Objects.equals(this.val(), ((ONode)o).val());
            }
            return Objects.equals(this.val(), o);
        }
        if (o instanceof ONode) {
            return ((ONode)o).isNull();
        }
        return false;
    }

    public int hashCode() {
        return this._d.hashCode();
    }
}

