/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.json.schema;

import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.visitor.XSVisitor;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jvnet.jax_ws_commons.json.SchemaConvention;
import org.jvnet.jax_ws_commons.json.SchemaWalker;
import org.jvnet.jax_ws_commons.json.schema.CompositeJsonType;
import org.jvnet.jax_ws_commons.json.schema.JsonType;

public class JsonTypeBuilder {
    private final SchemaConvention convention;
    private final Map<XSType, JsonType> types = new HashMap<XSType, JsonType>();
    private int id = 1;

    public JsonTypeBuilder(SchemaConvention convention) {
        this.convention = convention;
    }

    public JsonType create(XSType type) {
        JsonType jt = this.types.get(type);
        if (jt != null) {
            return jt;
        }
        if (type.isComplexType()) {
            final CompositeJsonType cjt = new CompositeJsonType(this.getTypeName(type));
            this.types.put(type, cjt);
            type.asComplexType().visit((XSVisitor)new SchemaWalker(){
                private boolean repeated;

                @Override
                public void particle(XSParticle particle) {
                    boolean r = this.repeated;
                    this.repeated |= particle.isRepeated();
                    super.particle(particle);
                    this.repeated = r;
                }

                @Override
                public void elementDecl(XSElementDecl decl) {
                    String j = ((JsonTypeBuilder)JsonTypeBuilder.this).convention.x2j.get(new QName(decl.getTargetNamespace(), decl.getName()));
                    if (cjt.properties.containsKey(j)) {
                        cjt.properties.put(j, cjt.properties.get(j).makeArray());
                    } else {
                        JsonType t = JsonTypeBuilder.this.create(decl.getType());
                        if (this.repeated) {
                            t = t.makeArray();
                        }
                        cjt.properties.put(j, t);
                    }
                }
            });
            return cjt;
        }
        XSSimpleType st = type.asSimpleType();
        if (st.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
            if ("decimal".equals(st.getName()) || "float".equals(st.getName()) || "double".equals(st.getName())) {
                return JsonType.NUMBER;
            }
            if ("boolean".equals(st.getName())) {
                return JsonType.BOOLEAN;
            }
            if ("anySimpleType".equals(st.getName())) {
                return JsonType.STRING;
            }
        }
        return this.create(type.getBaseType());
    }

    private String getTypeName(XSType type) {
        if (type.isLocal()) {
            return "anonymousType#" + this.id++;
        }
        String n = type.getName();
        return Character.toUpperCase(n.charAt(0)) + n.substring(1);
    }
}

