/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.json.schema;

import java.util.Set;
import org.jvnet.jax_ws_commons.json.schema.ArrayJsonType;
import org.jvnet.jax_ws_commons.json.schema.CompositeJsonType;

public abstract class JsonType {
    public static final JsonType NUMBER = new NumberType();
    public static final JsonType BOOLEAN = new BooleanType();
    public static final JsonType STRING = new StringType();

    public abstract String getLink();

    public final JsonType makeArray() {
        return new ArrayJsonType(this);
    }

    public JsonType unwrap() {
        return this;
    }

    public void listCompositeTypes(Set<CompositeJsonType> result) {
    }

    public static class StringType
    extends JsonType {
        @Override
        public String getLink() {
            return "STRING";
        }
    }

    public static class BooleanType
    extends JsonType {
        @Override
        public String getLink() {
            return "BOOLEAN";
        }
    }

    public static class NumberType
    extends JsonType {
        @Override
        public String getLink() {
            return "NUMBER";
        }
    }
}

