/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.json.schema;

import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPart;
import com.sun.xml.ws.api.model.wsdl.WSDLPartDescriptor;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSSchemaSet;
import java.beans.Introspector;
import java.util.Map;
import javax.jws.soap.SOAPBinding;
import org.jvnet.jax_ws_commons.json.schema.CompositeJsonType;
import org.jvnet.jax_ws_commons.json.schema.JsonType;
import org.jvnet.jax_ws_commons.json.schema.JsonTypeBuilder;

public class JsonOperation {
    public final String methodName;
    public final JsonType input;
    public final JsonType output;
    public final WSDLBoundOperation operation;

    public JsonOperation(WSDLBoundOperation bo, XSSchemaSet schemas, JsonTypeBuilder builder, SOAPBinding.Style style) {
        this.operation = bo;
        this.methodName = Introspector.decapitalize(bo.getName().getLocalPart());
        this.input = JsonOperation.build(this.operation.getOperation().getInput().getName(), schemas, bo.getInParts(), builder, style);
        this.output = JsonOperation.build(this.operation.getOperation().getOutput().getName(), schemas, bo.getOutParts(), builder, style).unwrap();
    }

    private static JsonType build(String name, XSSchemaSet schemas, Map<String, ? extends WSDLPart> parts, JsonTypeBuilder builder, SOAPBinding.Style style) {
        CompositeJsonType wrapper = new CompositeJsonType(name);
        for (Map.Entry<String, ? extends WSDLPart> in : parts.entrySet()) {
            if (!in.getValue().getBinding().isBody()) continue;
            WSDLPartDescriptor d = in.getValue().getDescriptor();
            switch (d.type()) {
                case ELEMENT: {
                    XSElementDecl decl = schemas.getElementDecl(d.name().getNamespaceURI(), d.name().getLocalPart());
                    wrapper.properties.put(in.getKey(), builder.create(decl.getType()));
                    break;
                }
                case TYPE: {
                    wrapper.properties.put(in.getKey(), builder.create(schemas.getType(d.name().getNamespaceURI(), d.name().getLocalPart())));
                }
            }
        }
        if (style == SOAPBinding.Style.DOCUMENT) {
            return wrapper.unwrap();
        }
        return wrapper;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public JsonType getInput() {
        return this.input;
    }

    public JsonType getOutput() {
        return this.output;
    }
}

