/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.json.schema;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jvnet.jax_ws_commons.json.schema.JsonType;

public class CompositeJsonType
extends JsonType {
    private final String name;
    public final Map<String, JsonType> properties = new LinkedHashMap<String, JsonType>();

    public CompositeJsonType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getLink() {
        return String.format("<a href=#%1$s>%1$s</a>", this.name);
    }

    @Override
    public JsonType unwrap() {
        if (this.properties.size() != 1) {
            return this;
        }
        return this.properties.values().iterator().next();
    }

    @Override
    public void listCompositeTypes(Set<CompositeJsonType> result) {
        if (result.add(this)) {
            for (JsonType t : this.properties.values()) {
                t.listCompositeTypes(result);
            }
        }
    }

    public Map<String, JsonType> getProperties() {
        return this.properties;
    }
}

