/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.json;

import com.sun.istack.NotNull;
import com.sun.istack.XMLStreamException2;
import com.sun.xml.bind.unmarshaller.DOMScanner;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamWriterBufferCreator;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.parser.JAXPParser;
import com.sun.xml.xsom.parser.XMLParser;
import com.sun.xml.xsom.parser.XSOMParser;
import com.sun.xml.xsom.visitor.XSVisitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.ws.WebServiceException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import org.jvnet.jax_ws_commons.json.MappedXMLStreamReader;
import org.jvnet.jax_ws_commons.json.MappedXMLStreamWriter;
import org.jvnet.jax_ws_commons.json.SchemaConvention;
import org.jvnet.jax_ws_commons.json.SchemaWalker;
import org.jvnet.jax_ws_commons.json.schema.CompositeJsonType;
import org.jvnet.jax_ws_commons.json.schema.JsonOperation;
import org.jvnet.jax_ws_commons.json.schema.JsonTypeBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SchemaInfo {
    @NotNull
    private final WSEndpoint endpoint;
    private final Set<QName> tagNames = new HashSet<QName>();
    final List<JsonOperation> operations = new ArrayList<JsonOperation>();
    final SchemaConvention convention;
    private static final SAXTransformerFactory saxTransformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
    private static final DocumentAddressResolver resolver = new DocumentAddressResolver(){

        public String getRelativeAddressFor(@NotNull SDDocument current, @NotNull SDDocument referenced) {
            return referenced.getURL().toExternalForm();
        }
    };

    public SchemaInfo(WSEndpoint endpoint) {
        this.endpoint = endpoint;
        ServiceDefinition sd = endpoint.getServiceDefinition();
        final HashMap<String, SDDocument> byURL = new HashMap<String, SDDocument>();
        for (SDDocument doc : sd) {
            byURL.put(doc.getURL().toExternalForm(), doc);
        }
        XSOMParser p = new XSOMParser(new XMLParser(){
            private final XMLParser jaxp = new JAXPParser();

            public void parse(InputSource source, ContentHandler handler, ErrorHandler errorHandler, EntityResolver entityResolver) throws SAXException, IOException {
                SDDocument doc = (SDDocument)byURL.get(source.getSystemId());
                if (doc != null) {
                    try {
                        SchemaInfo.readToBuffer(doc).writeTo(handler, errorHandler, false);
                    }
                    catch (XMLStreamException e) {
                        throw new SAXException(e);
                    }
                } else {
                    this.jaxp.parse(source, handler, errorHandler, entityResolver);
                }
            }
        });
        try {
            TransformerHandler h = saxTransformerFactory.newTransformerHandler();
            DOMResult r = new DOMResult();
            h.setResult(r);
            SchemaInfo.readToBuffer(sd.getPrimary()).writeTo((ContentHandler)h, false);
            Document dom = (Document)r.getNode();
            NodeList schemas = dom.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
            for (int i = 0; i < schemas.getLength(); ++i) {
                DOMScanner scanner = new DOMScanner();
                scanner.setContentHandler(p.getParserHandler());
                scanner.scan((Object)schemas.item(i));
            }
            this.extractTagNames(p.getResult());
            this.convention = new SchemaConvention(this.tagNames);
            if (endpoint.getPort() != null) {
                this.buildJsonSchema(p.getResult(), endpoint.getPort());
            }
        }
        catch (IOException | XMLStreamException | SAXException e) {
            throw new WebServiceException("Failed to parse WSDL", (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getServiceName() {
        String name = this.endpoint.getPort().getName().getLocalPart();
        if (name.endsWith("ServicePort")) {
            name = name.substring(0, name.length() - 4);
        }
        return name;
    }

    public XMLStreamWriter createXMLStreamWriter(Writer writer) {
        return new MappedXMLStreamWriter(this.convention, writer){

            @Override
            public void writeEndDocument() throws XMLStreamException {
                if (!this.stack.isEmpty()) {
                    throw new XMLStreamException("Missing some closing tags.");
                }
                try {
                    JSONObject root = (JSONObject)this.current.getValue();
                    root = root.getJSONObject((String)root.keys().next());
                    if (root == null) {
                        this.writer.write("null");
                    } else {
                        Object firstElement = root.get((String)root.keys().next());
                        if (root.length() == 1) {
                            if (firstElement == null) {
                                this.writer.write("null");
                            } else if (firstElement instanceof JSONArray) {
                                ((JSONArray)firstElement).write(this.writer);
                            } else {
                                root.write(this.writer);
                            }
                        } else {
                            root.write(this.writer);
                        }
                    }
                    this.writer.flush();
                }
                catch (IOException | JSONException e) {
                    throw new XMLStreamException2(e);
                }
            }
        };
    }

    public XMLStreamReader createXMLStreamReader(JSONTokener tokener) throws JSONException, XMLStreamException {
        JSONObject obj = new JSONObject(tokener);
        return new MappedXMLStreamReader(obj, this.convention);
    }

    private void extractTagNames(XSSchemaSet schemas) {
        SchemaWalker collector = new SchemaWalker(){

            @Override
            public void elementDecl(XSElementDecl decl) {
                SchemaInfo.this.tagNames.add(new QName(decl.getTargetNamespace(), decl.getName()));
            }
        };
        for (XSSchema s : schemas.getSchemas()) {
            s.visit((XSVisitor)collector);
        }
    }

    private static MutableXMLStreamBuffer readToBuffer(SDDocument doc) throws XMLStreamException, IOException {
        MutableXMLStreamBuffer buf = new MutableXMLStreamBuffer();
        doc.writeTo(null, resolver, (XMLStreamWriter)new StreamWriterBufferCreator(buf));
        return buf;
    }

    private void buildJsonSchema(XSSchemaSet schemas, WSDLPort port) {
        SOAPBinding.Style style = port.getBinding().getStyle();
        JsonTypeBuilder builder = new JsonTypeBuilder(this.convention);
        for (WSDLBoundOperation bo : port.getBinding().getBindingOperations()) {
            this.operations.add(new JsonOperation(bo, schemas, builder, style));
        }
    }

    public List<JsonOperation> getOperations() {
        return this.operations;
    }

    public Set<CompositeJsonType> getTypes() {
        LinkedHashSet<CompositeJsonType> r = new LinkedHashSet<CompositeJsonType>();
        for (JsonOperation op : this.operations) {
            op.input.listCompositeTypes(r);
            op.output.listCompositeTypes(r);
        }
        return r;
    }
}

