/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.json;

import com.sun.xml.bind.api.impl.NameConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.jettison.Node;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;

public class SchemaConvention
extends MappedNamespaceConvention {
    public final Map<QName, String> x2j = new HashMap<QName, String>();
    public final Map<String, QName> j2x = new HashMap<String, QName>();
    private static final Comparator<QName> QNAME_SORTER = new Comparator<QName>(){

        @Override
        public int compare(QName lhs, QName rhs) {
            int r = lhs.getNamespaceURI().compareTo(rhs.getNamespaceURI());
            if (r != 0) {
                return r;
            }
            return lhs.getLocalPart().compareTo(rhs.getLocalPart());
        }
    };

    public SchemaConvention(Collection<QName> tagNames) {
        QName[] names = tagNames.toArray(new QName[tagNames.size()]);
        Arrays.sort(names, QNAME_SORTER);
        block0: for (QName n : names) {
            int i;
            if (!this.j2x.containsKey(n.getLocalPart())) {
                this.register(n.getLocalPart(), n);
                continue;
            }
            String token = this.getLastNsToken(n);
            if (token != null) {
                for (i = 1; i < token.length(); ++i) {
                    String jsonName = token.substring(0, i) + '_' + n.getLocalPart();
                    if (this.j2x.containsKey(jsonName)) continue;
                    this.register(jsonName, n);
                    continue block0;
                }
            }
            i = 2;
            while (this.j2x.containsKey(n.getLocalPart() + i)) {
                ++i;
            }
            this.register(n.getLocalPart() + i, n);
        }
    }

    private void register(String jsonName, QName qName) {
        this.j2x.put(jsonName, qName);
        this.x2j.put(qName, jsonName);
    }

    private String getLastNsToken(QName n) {
        String[] tokens = n.getNamespaceURI().split("[/.:]");
        for (int i = tokens.length - 1; i >= 0; --i) {
            if (tokens[i].isEmpty()) continue;
            return NameConverter.standard.toVariableName(tokens[i]);
        }
        return null;
    }

    public QName createQName(String rootName, Node node) {
        QName qn = this.j2x.get(rootName);
        if (qn != null) {
            return qn;
        }
        return new QName(rootName);
    }

    public String createKey(String p, String ns, String local) {
        String json = this.x2j.get(new QName(ns, local));
        if (json != null) {
            return json;
        }
        return local;
    }

    public boolean isElement(String p, String ns, String local) {
        return false;
    }
}

