/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.json;

import com.sun.istack.NotNull;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.HttpMetadataPublisher;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.jvnet.jax_ws_commons.json.ClientGenerator;
import org.jvnet.jax_ws_commons.json.QueryStringParser;
import org.jvnet.jax_ws_commons.json.SchemaInfo;

final class MetadataPublisherImpl
extends HttpMetadataPublisher {
    private final SchemaInfo model;

    public MetadataPublisherImpl(SchemaInfo model) {
        this.model = model;
    }

    public boolean handleMetadataRequest(@NotNull HttpAdapter adapter, @NotNull WSHTTPConnection con) throws IOException {
        QueryStringParser qsp = new QueryStringParser(con);
        if (qsp.containsKey("js")) {
            con.setStatus(200);
            con.setContentTypeResponseHeader("application/javascript;charset=utf-8");
            ClientGenerator gen = new ClientGenerator(this.model, con, adapter);
            String varName = (String)qsp.get("var");
            if (varName != null) {
                gen.setVariableName(varName);
            }
            gen.generate(new PrintWriter(new OutputStreamWriter(con.getOutput(), "UTF-8")));
            return true;
        }
        if (con.getQueryString() == null || qsp.containsKey("help")) {
            con.setStatus(200);
            con.setContentTypeResponseHeader("text/html;charset=UTF-8");
            this.generateHelpHtml(con, adapter, new OutputStreamWriter(con.getOutput(), "UTF-8"));
            return true;
        }
        URL res = ((Object)((Object)this)).getClass().getResource("template/" + con.getQueryString());
        if (res != null) {
            int len;
            con.setStatus(200);
            if (res.getPath().endsWith(".gif")) {
                con.setContentTypeResponseHeader("image/gif");
            }
            if (res.getPath().endsWith(".css")) {
                con.setContentTypeResponseHeader("text/css");
            }
            InputStream is = res.openStream();
            OutputStream os = con.getOutput();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
            return true;
        }
        return false;
    }

    void generateHelpHtml(WSHTTPConnection con, HttpAdapter adapter, OutputStreamWriter writer) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("model", (Object)this.model);
        context.put("requestURL", (Object)(con.getBaseAddress() + adapter.urlPattern));
        new VelocityEngine().evaluate((Context)context, (Writer)writer, "velocity", (Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("template/index.html"), "UTF-8"));
        writer.close();
    }
}

