/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.json;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.api.server.EndpointAwareCodec;
import com.sun.xml.ws.api.server.EndpointComponent;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.HttpMetadataPublisher;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONTokener;
import org.jvnet.jax_ws_commons.json.MetadataPublisherImpl;
import org.jvnet.jax_ws_commons.json.SchemaInfo;

class JSONCodec
implements EndpointAwareCodec,
EndpointComponent {
    private static final String JSON_MIME_TYPE = "application/json";
    private static final ContentType jsonContentType = new JSONContentType();
    private final WSBinding binding;
    private final SOAPVersion soapVersion;
    private SchemaInfo schemaInfo;
    private HttpMetadataPublisher metadataPublisher;
    private WSEndpoint endpoint;

    public JSONCodec(WSBinding binding) {
        this.binding = binding;
        this.soapVersion = binding.getSOAPVersion();
    }

    public JSONCodec(JSONCodec that) {
        this(that.binding);
        this.schemaInfo = that.schemaInfo;
        this.endpoint = that.endpoint;
    }

    public void setEndpoint(WSEndpoint endpoint) {
        this.endpoint = endpoint;
        this.schemaInfo = new SchemaInfo(endpoint);
        endpoint.getComponentRegistry().add(this);
    }

    public String getMimeType() {
        return JSON_MIME_TYPE;
    }

    public ContentType getStaticContentType(Packet packet) {
        return jsonContentType;
    }

    @Nullable
    public <T> T getSPI(@NotNull Class<T> type) {
        if (type == HttpMetadataPublisher.class) {
            if (this.metadataPublisher == null) {
                this.metadataPublisher = new MetadataPublisherImpl(this.checkSchemaInfo());
            }
            return type.cast(this.metadataPublisher);
        }
        return null;
    }

    public ContentType encode(Packet packet, OutputStream out) throws IOException {
        Message message = packet.getMessage();
        if (message != null) {
            XMLStreamWriter sw = null;
            try {
                sw = this.checkSchemaInfo().createXMLStreamWriter(new OutputStreamWriter(out, "UTF-8"));
                sw.writeStartDocument();
                message.writePayloadTo(sw);
                sw.writeEndDocument();
            }
            catch (XMLStreamException xe) {
                throw new WebServiceException((Throwable)xe);
            }
            finally {
                if (sw != null) {
                    try {
                        sw.close();
                    }
                    catch (XMLStreamException xMLStreamException) {}
                }
            }
        }
        return jsonContentType;
    }

    public ContentType encode(Packet packet, WritableByteChannel buffer) {
        throw new UnsupportedOperationException();
    }

    private SchemaInfo checkSchemaInfo() {
        if (this.schemaInfo == null) {
            throw new IllegalStateException("JSON binding is only available for the server");
        }
        return this.schemaInfo;
    }

    public Codec copy() {
        return new JSONCodec(this);
    }

    public void decode(InputStream in, String contentType, Packet response) throws IOException {
        Message message;
        try {
            int len;
            StringWriter sw = new StringWriter();
            InputStreamReader r = new InputStreamReader(in, "UTF-8");
            char[] buf = new char[1024];
            while ((len = r.read(buf)) >= 0) {
                sw.write(buf, 0, len);
            }
            ((Reader)r).close();
            if (sw.getBuffer().length() == 0) {
                message = Messages.createEmpty((SOAPVersion)this.soapVersion);
            } else {
                String incomingPacket = sw.toString();
                XMLStreamReader reader = this.checkSchemaInfo().createXMLStreamReader(new JSONTokener(incomingPacket));
                message = Messages.createUsingPayload((XMLStreamReader)reader, (SOAPVersion)this.soapVersion);
            }
        }
        catch (XMLStreamException | JSONException e) {
            throw new WebServiceException(e);
        }
        response.setMessage(message);
    }

    public void decode(ReadableByteChannel in, String contentType, Packet response) {
        throw new UnsupportedOperationException();
    }

    private static final class JSONContentType
    implements ContentType {
        private static final String JSON_CONTENT_TYPE = "application/json";

        private JSONContentType() {
        }

        public String getContentType() {
            return "application/json";
        }

        public String getSOAPActionHeader() {
            return null;
        }

        public String getAcceptHeader() {
            return "application/json";
        }
    }
}

