/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.json;

import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Iterator;
import org.jvnet.jax_ws_commons.json.SchemaInfo;
import org.jvnet.jax_ws_commons.json.schema.JsonOperation;

final class ClientGenerator {
    private final SchemaInfo model;
    private final WSHTTPConnection connection;
    private final HttpAdapter adapter;
    private String name;

    public ClientGenerator(SchemaInfo model, WSHTTPConnection connection, HttpAdapter adapter) {
        this.model = model;
        this.connection = connection;
        this.adapter = adapter;
        this.name = Introspector.decapitalize(model.getServiceName());
    }

    public void setVariableName(String name) {
        this.name = name;
    }

    void generate(PrintWriter os) throws IOException {
        this.writeGlobal(os);
        this.writeStatic(os);
        this.writeOperations(os);
        ClientGenerator.writeClosure(os);
        os.close();
    }

    private void writeGlobal(PrintWriter os) {
        os.printf("%s = {\n", this.name);
        ClientGenerator.shift(os);
        os.printf("url : \"%s\",\n", this.connection.getBaseAddress() + this.adapter.urlPattern);
    }

    private void writeStatic(PrintWriter os) throws IOException {
        int len;
        InputStreamReader is = new InputStreamReader(this.getClass().getResourceAsStream("jaxws.js"));
        char[] buf = new char[256];
        while ((len = is.read(buf)) != -1) {
            os.write(buf, 0, len);
        }
        ((Reader)is).close();
    }

    private void writeOperations(PrintWriter os) {
        Iterator<JsonOperation> it = this.model.operations.iterator();
        while (it.hasNext()) {
            this.writeOperation(it.next(), it.hasNext(), os);
        }
    }

    private void writeOperation(JsonOperation op, boolean next, PrintWriter os) {
        String reqName = this.model.convention.x2j.get(op.operation.getRequestPayloadName());
        ClientGenerator.shift(os);
        os.printf("%s : function(obj, callback) {\n", op.methodName);
        ClientGenerator.shift2(os);
        os.printf("this.post({%s:obj},callback);\n", reqName);
        ClientGenerator.shift(os);
        if (next) {
            os.append("},\n\n");
        } else {
            os.append("}\n\n");
        }
    }

    private static void shift(PrintWriter os) {
        os.append("    ");
    }

    private static void shift2(PrintWriter os) {
        ClientGenerator.shift(os);
        ClientGenerator.shift(os);
    }

    private static void writeClosure(PrintWriter os) {
        os.println("};");
    }
}

