/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.util.LinkedList;
import java.util.List;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.impl.proc.Procedures;

public class HarnessRegisteredProcs {
    private final List<Class<?>> procs = new LinkedList();
    private final List<Class<?>> functions = new LinkedList();
    private final List<Class<?>> aggregationFunctions = new LinkedList();

    public void addProcedure(Class<?> procedureClass) {
        this.procs.add(procedureClass);
    }

    public void addFunction(Class<?> functionClass) {
        this.functions.add(functionClass);
    }

    public void addAggregationFunction(Class<?> functionClass) {
        this.aggregationFunctions.add(functionClass);
    }

    public void applyTo(Procedures procedures) throws KernelException {
        for (Class<?> cls : this.procs) {
            procedures.registerProcedure(cls);
        }
        for (Class<?> cls : this.functions) {
            procedures.registerFunction(cls);
        }
        for (Class<?> cls : this.aggregationFunctions) {
            procedures.registerAggregationFunction(cls);
        }
    }
}

