/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher;

import java.util.regex.Pattern;
import org.neo4j.ogm.cypher.PropertyValueTransformer;

public class CaseInsensitiveLikePropertyValueTransformer
implements PropertyValueTransformer {
    private static final Pattern CHARS_TO_ESCAPE = Pattern.compile("([{}()\\[\\]^$?.+\\\\|!])");

    @Override
    public Object transformPropertyValue(Object propertyValue) {
        return propertyValue != null ? "(?i)" + CaseInsensitiveLikePropertyValueTransformer.escapeRegexCharacters(propertyValue.toString()).replaceAll("\\*", ".*") : null;
    }

    private static String escapeRegexCharacters(String propertyValue) {
        return CHARS_TO_ESCAPE.matcher(propertyValue).replaceAll("\\\\$1");
    }
}

