/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.Index;
import org.neo4j.ogm.annotation.Labels;
import org.neo4j.ogm.annotation.Properties;
import org.neo4j.ogm.annotation.Property;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.Version;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.id.InternalIdStrategy;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DescriptorMappings;
import org.neo4j.ogm.metadata.ObjectAnnotations;
import org.neo4j.ogm.metadata.reflect.GenericUtils;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.typeconversion.CompositeAttributeConverter;
import org.neo4j.ogm.typeconversion.MapCompositeConverter;
import org.neo4j.ogm.utils.RelationshipUtils;

public class FieldInfo {
    private final String name;
    private final String descriptor;
    private final String typeParameterDescriptor;
    private final ObjectAnnotations annotations;
    private final boolean isArray;
    private final boolean isSupportedNativeType;
    private final ClassInfo containingClassInfo;
    private final Field delegateHolder;
    private final Field field;
    private final Class<?> fieldType;
    private AttributeConverter<?, ?> propertyConverter;
    private CompositeAttributeConverter<?> compositeConverter;

    FieldInfo(ClassInfo classInfo, Field delegateHolder, Field field, String typeParameterDescriptor, ObjectAnnotations annotations, Predicate<Class<?>> isSupportedNativeType) {
        this.containingClassInfo = classInfo;
        this.delegateHolder = delegateHolder;
        this.field = field;
        this.fieldType = GenericUtils.isGenericField(field) ? GenericUtils.findFieldType(field, classInfo.getUnderlyingClass()) : field.getType();
        this.isArray = this.fieldType.isArray();
        this.name = field.getName();
        this.descriptor = this.fieldType.getTypeName();
        this.typeParameterDescriptor = typeParameterDescriptor;
        this.annotations = annotations;
        this.isSupportedNativeType = isSupportedNativeType.test(DescriptorMappings.getType(this.getTypeDescriptor()));
        if (!this.annotations.isEmpty()) {
            Object converter = this.getAnnotations().getConverter(this.fieldType);
            if (converter instanceof AttributeConverter) {
                this.setPropertyConverter((AttributeConverter)converter);
            } else if (converter instanceof CompositeAttributeConverter) {
                this.setCompositeConverter((CompositeAttributeConverter)converter);
            } else {
                if (converter != null) {
                    throw new IllegalStateException(String.format("The converter for field %s is neither an instance of AttributeConverter or CompositeAttributeConverter", this.name));
                }
                if (this.hasAnnotation(Properties.class)) {
                    if (this.fieldType.equals(Map.class)) {
                        Properties propertiesAnnotation = (Properties)this.getAnnotations().get(Properties.class).getAnnotation();
                        Type fieldGenericType = field.getGenericType();
                        MapCompositeConverter mapCompositeConverter = new MapCompositeConverter(Optional.ofNullable(propertiesAnnotation.prefix()).filter(StringUtils::isNotBlank).orElseGet(field::getName), propertiesAnnotation.delimiter(), propertiesAnnotation.allowCast(), (ParameterizedType)fieldGenericType, isSupportedNativeType);
                        try {
                            mapCompositeConverter.setEnumKeysTransformation(propertiesAnnotation.transformEnumKeysWith().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Unsupported property key filter: " + propertiesAnnotation.transformEnumKeysWith(), e);
                        }
                        this.setCompositeConverter(mapCompositeConverter);
                    } else {
                        throw new MappingException("@Properties annotation is allowed only on fields of type java.util.Map");
                    }
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String property() {
        if (this.persistableAsProperty()) {
            AnnotationInfo propertyAnnotation;
            if (this.annotations != null && (propertyAnnotation = this.annotations.get(Property.class)) != null) {
                return propertyAnnotation.get("name", this.getName());
            }
            return this.getName();
        }
        return null;
    }

    public String relationship() {
        if (this.containingClassInfo.relationshipFields().contains(this)) {
            AnnotationInfo relationshipAnnotation;
            if (this.annotations != null && (relationshipAnnotation = this.annotations.get(Relationship.class)) != null) {
                return relationshipAnnotation.get("type", RelationshipUtils.inferRelationshipType(this.getName()));
            }
            return RelationshipUtils.inferRelationshipType(this.getName());
        }
        return null;
    }

    public String relationshipTypeAnnotation() {
        AnnotationInfo relationshipAnnotation;
        if (!this.persistableAsProperty() && this.annotations != null && (relationshipAnnotation = this.annotations.get(Relationship.class)) != null) {
            return relationshipAnnotation.get("type", null);
        }
        return null;
    }

    public ObjectAnnotations getAnnotations() {
        return this.annotations;
    }

    public boolean persistableAsProperty() {
        return DescriptorMappings.describesPrimitve(this.descriptor) || this.isSupportedNativeType || DescriptorMappings.describesWrapper(this.getTypeDescriptor()) || this.propertyConverter != null || this.compositeConverter != null;
    }

    public AttributeConverter getPropertyConverter() {
        return this.propertyConverter;
    }

    public void setPropertyConverter(AttributeConverter<?, ?> propertyConverter) {
        if (this.propertyConverter == null && this.compositeConverter == null && propertyConverter != null) {
            this.propertyConverter = propertyConverter;
        }
    }

    public boolean hasPropertyConverter() {
        return this.propertyConverter != null;
    }

    public CompositeAttributeConverter getCompositeConverter() {
        return this.compositeConverter;
    }

    public void setCompositeConverter(CompositeAttributeConverter<?> converter) {
        if (this.propertyConverter == null && this.compositeConverter == null && converter != null) {
            this.compositeConverter = converter;
        }
    }

    public boolean hasCompositeConverter() {
        return this.compositeConverter != null;
    }

    public String relationshipDirection(String defaultDirection) {
        if (this.relationship() != null) {
            AnnotationInfo annotationInfo = this.getAnnotations().get(Relationship.class);
            if (annotationInfo == null) {
                return defaultDirection;
            }
            return annotationInfo.get("direction", defaultDirection);
        }
        throw new RuntimeException("relationship direction call invalid");
    }

    public boolean isIterable() {
        return Iterable.class.isAssignableFrom(this.fieldType);
    }

    public boolean isTypeOf(Class<?> type) {
        return FieldInfo.doesDescriptorMatchType(this.descriptor, type);
    }

    public boolean isParameterisedTypeOf(Class<?> type) {
        return FieldInfo.doesDescriptorMatchType(this.typeParameterDescriptor, type);
    }

    public boolean isArrayOf(Class<?> type) {
        while (type != null) {
            String typeSignature = type.getName();
            if (this.descriptor != null && this.descriptor.equals(typeSignature + "[]")) {
                return true;
            }
            for (Class<?> iface : type.getInterfaces()) {
                typeSignature = iface.getName();
                if (this.descriptor == null || !this.descriptor.equals(typeSignature)) continue;
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public String getCollectionClassname() {
        return this.descriptor;
    }

    public boolean isScalar() {
        return !this.isIterable() && !this.isArray();
    }

    public boolean isLabelField() {
        return this.getAnnotations().get(Labels.class) != null;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean hasAnnotation(String annotationName) {
        return this.getAnnotations().get(annotationName) != null;
    }

    public boolean hasAnnotation(Class<?> annotationNameClass) {
        return this.getAnnotations().get(annotationNameClass.getName()) != null;
    }

    public String getTypeDescriptor() {
        if (!this.isIterable() || this.isArray()) {
            return this.descriptor;
        }
        return this.typeParameterDescriptor;
    }

    public Class<?> convertedType() {
        if (this.hasPropertyConverter() || this.hasCompositeConverter()) {
            Class<?> converterClass = this.hasPropertyConverter() ? this.getPropertyConverter().getClass() : this.getCompositeConverter().getClass();
            String methodName = this.hasPropertyConverter() ? "toGraphProperty" : "toGraphProperties";
            try {
                for (Method method : converterClass.getDeclaredMethods()) {
                    if (!method.getName().equals(methodName) || method.isSynthetic()) continue;
                    return method.getReturnType();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public boolean isConstraint() {
        AnnotationInfo idAnnotation = this.getAnnotations().get(Id.class.getName());
        if (idAnnotation != null) {
            return true;
        }
        AnnotationInfo indexAnnotation = this.getAnnotations().get(Index.class.getName());
        return indexAnnotation != null && indexAnnotation.get("unique", "false").equals("true");
    }

    public static void write(Field field, Object instance, Object value) {
        AccessController.doPrivileged(() -> {
            try {
                field.setAccessible(true);
                field.set(instance, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    public static Object read(Field field, Object instance) {
        return AccessController.doPrivileged(() -> {
            try {
                field.setAccessible(true);
                return field.get(instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void write(Object instance, Object value) {
        if (this.hasPropertyConverter()) {
            value = this.getPropertyConverter().toEntityAttribute(value);
        } else if (this.isScalar()) {
            String actualTypeDescriptor = this.getTypeDescriptor();
            value = Utils.coerceTypes(DescriptorMappings.getType(actualTypeDescriptor), value);
        }
        FieldInfo.write(this.field, ClassInfo.getInstanceOrDelegate(instance, this.delegateHolder), value);
    }

    public void writeDirect(Object instance, Object value) {
        FieldInfo.write(this.field, instance, value);
    }

    public Class<?> type() {
        Class<?> convertedType = this.convertedType();
        if (convertedType != null) {
            return convertedType;
        }
        return this.fieldType;
    }

    public String relationshipName() {
        return this.relationship();
    }

    public boolean forScalar() {
        return !Iterable.class.isAssignableFrom(this.type()) && !this.type().isArray();
    }

    public String typeParameterDescriptor() {
        return this.getTypeDescriptor();
    }

    public Object read(Object instance) {
        return FieldInfo.read(this.containingClassInfo.getField(this), ClassInfo.getInstanceOrDelegate(instance, this.delegateHolder));
    }

    public Object readProperty(Object instance) {
        if (this.hasCompositeConverter()) {
            throw new IllegalStateException("The readComposite method should be used for fields with a CompositeAttributeConverter");
        }
        Object value = FieldInfo.read(this.containingClassInfo.getField(this), ClassInfo.getInstanceOrDelegate(instance, this.delegateHolder));
        if (this.hasPropertyConverter()) {
            value = this.getPropertyConverter().toGraphProperty(value);
        }
        return value;
    }

    public Map<String, ?> readComposite(Object instance) {
        if (!this.hasCompositeConverter()) {
            throw new IllegalStateException("readComposite should only be used when a field is annotated with a CompositeAttributeConverter");
        }
        Object value = FieldInfo.read(this.containingClassInfo.getField(this), ClassInfo.getInstanceOrDelegate(instance, this.delegateHolder));
        return this.getCompositeConverter().toGraphProperties(value);
    }

    public String relationshipType() {
        return this.relationship();
    }

    public String propertyName() {
        return this.property();
    }

    public boolean isComposite() {
        return this.hasCompositeConverter();
    }

    public String relationshipDirection() {
        AnnotationInfo relationshipAnnotation;
        ObjectAnnotations annotationOfField = this.getAnnotations();
        if (annotationOfField != null && (relationshipAnnotation = annotationOfField.get(Relationship.class)) != null) {
            return relationshipAnnotation.get("direction", "UNDIRECTED");
        }
        return "UNDIRECTED";
    }

    public String typeDescriptor() {
        return this.getTypeDescriptor();
    }

    public Field getField() {
        return this.field;
    }

    public ClassInfo containingClassInfo() {
        return this.containingClassInfo;
    }

    public boolean isVersionField() {
        return this.field.getAnnotation(Version.class) != null;
    }

    boolean isInternalIdentity() {
        return this.getAnnotations().has(Id.class) && this.getAnnotations().has(GeneratedValue.class) && ((GeneratedValue)this.getAnnotations().get(GeneratedValue.class).getAnnotation()).strategy().equals(InternalIdStrategy.class);
    }

    private static boolean doesDescriptorMatchType(String descriptor, Class<?> type) {
        while (type != null) {
            if (FieldInfo.doesDescriptorMatchTypeOrInterface(descriptor, type)) {
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    private static boolean doesDescriptorMatchTypeOrInterface(String descriptorToMatch, Class<?> type) {
        String typeSignature = type.getName();
        if (descriptorToMatch != null && descriptorToMatch.equals(typeSignature)) {
            return true;
        }
        return FieldInfo.doesAnyInterfaceMatch(descriptorToMatch, type);
    }

    private static boolean doesAnyInterfaceMatch(String descriptor, Class<?> type) {
        for (Class<?> interfaceClass : type.getInterfaces()) {
            if (!FieldInfo.doesDescriptorMatchTypeOrInterface(descriptor, interfaceClass)) continue;
            return true;
        }
        return false;
    }
}

