/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.ogm.annotation.CompositeIndex;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.Index;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.PostLoad;
import org.neo4j.ogm.annotation.Property;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.Required;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.annotation.Transient;
import org.neo4j.ogm.driver.TypeSystem;
import org.neo4j.ogm.exception.core.InvalidPropertyFieldException;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.exception.core.MetadataException;
import org.neo4j.ogm.id.IdStrategy;
import org.neo4j.ogm.id.InternalIdStrategy;
import org.neo4j.ogm.id.UuidStrategy;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.AnnotationsInfo;
import org.neo4j.ogm.metadata.DescriptorMappings;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.FieldsInfo;
import org.neo4j.ogm.metadata.InterfacesInfo;
import org.neo4j.ogm.metadata.KotlinDetector;
import org.neo4j.ogm.metadata.MethodInfo;
import org.neo4j.ogm.metadata.MethodsInfo;
import org.neo4j.ogm.support.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassInfo.class);
    private final List<ClassInfo> directSubclasses = new ArrayList<ClassInfo>();
    private final List<ClassInfo> directInterfaces = new ArrayList<ClassInfo>();
    private final List<ClassInfo> directImplementingClasses = new ArrayList<ClassInfo>();
    private final List<ClassInfo> indirectSuperClasses = new ArrayList<ClassInfo>();
    private String className;
    private String directSuperclassName;
    private String neo4jName;
    private boolean isInterface;
    private boolean isAbstract;
    private boolean isEnum;
    private FieldsInfo fieldsInfo;
    private MethodsInfo methodsInfo;
    private AnnotationsInfo annotationsInfo;
    private InterfacesInfo interfacesInfo;
    private ClassInfo directSuperclass;
    private Map<Class, List<FieldInfo>> iterableFieldsForType = new HashMap<Class, List<FieldInfo>>();
    private Map<FieldInfo, Field> fieldInfoFields = new ConcurrentHashMap<FieldInfo, Field>();
    private volatile Set<FieldInfo> fieldInfos;
    private volatile Map<String, FieldInfo> propertyFields;
    private volatile Map<String, FieldInfo> indexFields;
    private volatile Collection<FieldInfo> requiredFields;
    private volatile Collection<CompositeIndex> compositeIndexes;
    private volatile Optional<FieldInfo> identityField;
    private volatile Optional<FieldInfo> versionField;
    private volatile FieldInfo primaryIndexField = null;
    private volatile FieldInfo labelField = null;
    private volatile boolean labelFieldMapped = false;
    private volatile boolean isPostLoadMethodMapped = false;
    private volatile MethodInfo postLoadMethod;
    private boolean primaryIndexFieldChecked = false;
    private Class<?> cls;
    private Class<? extends IdStrategy> idStrategyClass;
    private IdStrategy idStrategy;

    public ClassInfo(Class<?> cls, TypeSystem typeSystem) {
        this(cls, null, typeSystem);
    }

    private ClassInfo(Class<?> cls, Field parent, TypeSystem typeSystem) {
        this.cls = cls;
        int modifiers = cls.getModifiers();
        this.isInterface = Modifier.isInterface(modifiers);
        this.isAbstract = Modifier.isAbstract(modifiers);
        this.isEnum = ClassUtils.isEnum(cls);
        this.className = cls.getName();
        if (cls.getSuperclass() != null) {
            this.directSuperclassName = cls.getSuperclass().getName();
        }
        this.interfacesInfo = new InterfacesInfo(cls);
        this.fieldsInfo = new FieldsInfo(this, cls, parent, typeSystem);
        this.methodsInfo = new MethodsInfo(cls, parent);
        this.annotationsInfo = new AnnotationsInfo(cls);
        if (this.isRelationshipEntity() && this.labelFieldOrNull() != null) {
            throw new MappingException(String.format("'%s' is a relationship entity. The @Labels annotation can't be applied to relationship entities.", this.name()));
        }
        for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
            if (!fieldInfo.hasAnnotation(Property.class) || !fieldInfo.hasCompositeConverter()) continue;
            throw new MappingException(String.format("'%s' has both @Convert and @Property annotations applied to the field '%s'", this.name(), fieldInfo.getName()));
        }
        if (KotlinDetector.isKotlinType(cls)) {
            this.inspectLocalDelegates(typeSystem);
        }
    }

    private void inspectLocalDelegates(TypeSystem typeSystem) {
        for (Field field : this.cls.getDeclaredFields()) {
            if (!ClassInfo.isKotlinDelegate(field)) continue;
            ClassInfo indirectSuperClass = new ClassInfo(field.getType(), field, typeSystem);
            this.extend(indirectSuperClass);
            this.indirectSuperClasses.add(indirectSuperClass);
        }
    }

    private static boolean isKotlinDelegate(Field field) {
        return field.isSynthetic() && field.getName().startsWith("$$delegate_");
    }

    void extend(ClassInfo classInfo) {
        this.interfacesInfo.append(classInfo.interfacesInfo());
        this.fieldsInfo.append(classInfo.fieldsInfo());
        this.methodsInfo.append(classInfo.methodsInfo());
    }

    void addSubclass(ClassInfo subclass) {
        if (subclass.directSuperclass != null && subclass.directSuperclass != this) {
            throw new RuntimeException(subclass.className + " has two superclasses: " + subclass.directSuperclass.className + ", " + this.className);
        }
        subclass.directSuperclass = this;
        this.directSubclasses.add(subclass);
    }

    public String name() {
        return this.className;
    }

    String simpleName() {
        return ClassInfo.deriveSimpleName(this.cls);
    }

    public static String deriveSimpleName(Class<?> clazz) {
        String className = clazz.getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public ClassInfo directSuperclass() {
        return this.directSuperclass;
    }

    public Collection<String> staticLabels() {
        return this.collectLabels(new ArrayList<String>());
    }

    public String neo4jName() {
        if (this.neo4jName == null) {
            AnnotationInfo annotationInfo = this.annotationsInfo.get(NodeEntity.class);
            if (annotationInfo != null) {
                this.neo4jName = annotationInfo.get("label", this.simpleName());
                return this.neo4jName;
            }
            annotationInfo = this.annotationsInfo.get(RelationshipEntity.class);
            if (annotationInfo != null) {
                this.neo4jName = annotationInfo.get("type", this.simpleName().toUpperCase());
                return this.neo4jName;
            }
            if (!this.isAbstract) {
                this.neo4jName = this.simpleName();
            }
        }
        return this.neo4jName;
    }

    private Collection<String> collectLabels(Collection<String> labelNames) {
        if (!this.isAbstract || this.annotationsInfo.get(NodeEntity.class) != null) {
            labelNames.add(this.neo4jName());
        }
        if (this.directSuperclass != null && !"java.lang.Object".equals(this.directSuperclass.className)) {
            this.directSuperclass.collectLabels(labelNames);
        }
        for (ClassInfo interfaceInfo : this.directInterfaces()) {
            interfaceInfo.collectLabels(labelNames);
        }
        for (ClassInfo indirectSuperClass : this.indirectSuperClasses) {
            indirectSuperClass.collectLabels(labelNames);
        }
        return labelNames;
    }

    public List<ClassInfo> directSubclasses() {
        return this.directSubclasses;
    }

    List<ClassInfo> directImplementingClasses() {
        return this.directImplementingClasses;
    }

    List<ClassInfo> directInterfaces() {
        return this.directInterfaces;
    }

    InterfacesInfo interfacesInfo() {
        return this.interfacesInfo;
    }

    public Collection<AnnotationInfo> annotations() {
        return this.annotationsInfo.list();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public AnnotationsInfo annotationsInfo() {
        return this.annotationsInfo;
    }

    String superclassName() {
        return this.directSuperclassName;
    }

    public FieldsInfo fieldsInfo() {
        return this.fieldsInfo;
    }

    MethodsInfo methodsInfo() {
        return this.methodsInfo;
    }

    public FieldInfo identityFieldOrNull() {
        this.initIdentityField();
        return this.identityField.orElse(null);
    }

    public FieldInfo identityField() {
        this.initIdentityField();
        return this.identityField.orElseThrow(() -> new MetadataException("No internal identity field found for class: " + this.className));
    }

    private synchronized void initIdentityField() {
        if (this.identityField != null) {
            return;
        }
        Collection<FieldInfo> identityFields = this.getFieldInfos(FieldInfo::isInternalIdentity);
        if (identityFields.size() == 1) {
            this.identityField = Optional.of(identityFields.iterator().next());
        } else {
            if (identityFields.size() > 1) {
                throw new MetadataException("Expected exactly one internal identity field (@Id with InternalIdStrategy), found " + identityFields.size() + " " + identityFields);
            }
            this.identityField = this.fieldsInfo.fields().stream().filter(f -> "id".equals(f.getName())).filter(f -> "java.lang.Long".equals(f.getTypeDescriptor())).findFirst();
        }
    }

    public boolean hasIdentityField() {
        this.initIdentityField();
        return this.identityField.isPresent();
    }

    Collection<FieldInfo> getFieldInfos(Predicate<FieldInfo> predicate) {
        return this.fieldsInfo().fields().stream().filter(predicate).collect(Collectors.toSet());
    }

    public FieldInfo labelFieldOrNull() {
        if (this.labelFieldMapped) {
            return this.labelField;
        }
        if (!this.labelFieldMapped) {
            for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                if (!fieldInfo.isLabelField()) continue;
                if (!fieldInfo.isIterable()) {
                    throw new MappingException(String.format("Field '%s' in class '%s' includes the @Labels annotation, however this field is not a type of collection.", fieldInfo.getName(), this.name()));
                }
                this.labelFieldMapped = true;
                this.labelField = fieldInfo;
                return this.labelField;
            }
            this.labelFieldMapped = true;
        }
        return null;
    }

    public boolean isRelationshipEntity() {
        for (AnnotationInfo info : this.annotations()) {
            if (!info.getName().equals(RelationshipEntity.class.getName())) continue;
            return true;
        }
        return false;
    }

    public Collection<FieldInfo> propertyFields() {
        if (this.fieldInfos == null) {
            this.initPropertyFields();
        }
        return this.fieldInfos;
    }

    public FieldInfo propertyField(String propertyName) {
        if (this.propertyFields == null) {
            this.initPropertyFields();
        }
        return propertyName == null ? null : this.propertyFields.get(propertyName);
    }

    private synchronized void initPropertyFields() {
        if (this.fieldInfos != null) {
            return;
        }
        Collection<FieldInfo> fields = this.fieldsInfo().fields();
        FieldInfo optionalIdentityField = this.identityFieldOrNull();
        HashSet<FieldInfo> fieldInfos = new HashSet<FieldInfo>(fields.size());
        HashMap<String, FieldInfo> propertyFields = new HashMap<String, FieldInfo>(fields.size());
        for (FieldInfo fieldInfo : fields) {
            if (fieldInfo == optionalIdentityField || fieldInfo.isLabelField() || fieldInfo.hasAnnotation(StartNode.class) || fieldInfo.hasAnnotation(EndNode.class)) continue;
            if (!fieldInfo.getAnnotations().has(Property.class)) {
                if (!fieldInfo.persistableAsProperty()) continue;
                fieldInfos.add(fieldInfo);
                propertyFields.put(fieldInfo.property(), fieldInfo);
                continue;
            }
            if (fieldInfo.persistableAsProperty()) {
                fieldInfos.add(fieldInfo);
                propertyFields.put(fieldInfo.property(), fieldInfo);
                continue;
            }
            throw new InvalidPropertyFieldException(fieldInfo);
        }
        this.fieldInfos = fieldInfos;
        this.propertyFields = propertyFields;
    }

    public FieldInfo propertyFieldByName(String propertyName) {
        for (FieldInfo fieldInfo : this.propertyFields()) {
            if (!fieldInfo.getName().equalsIgnoreCase(propertyName)) continue;
            return fieldInfo;
        }
        return null;
    }

    public Collection<FieldInfo> relationshipFields() {
        FieldInfo optionalIdentityField = this.identityFieldOrNull();
        HashSet<FieldInfo> relationshipFields = new HashSet<FieldInfo>();
        for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
            if (fieldInfo == optionalIdentityField) continue;
            if (!fieldInfo.getAnnotations().has(Relationship.class)) {
                if (fieldInfo.persistableAsProperty()) continue;
                relationshipFields.add(fieldInfo);
                continue;
            }
            relationshipFields.add(fieldInfo);
        }
        return relationshipFields;
    }

    public FieldInfo relationshipField(String relationshipName) {
        for (FieldInfo fieldInfo : this.relationshipFields()) {
            if (!fieldInfo.relationship().equalsIgnoreCase(relationshipName)) continue;
            return fieldInfo;
        }
        return null;
    }

    public FieldInfo relationshipField(String relationshipName, String relationshipDirection, boolean strict) {
        for (FieldInfo fieldInfo : this.relationshipFields()) {
            String relationship = strict ? fieldInfo.relationshipTypeAnnotation() : fieldInfo.relationship();
            if (!relationshipName.equalsIgnoreCase(relationship) || (!fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING") && !fieldInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED") || !relationshipDirection.equals("INCOMING")) && (!relationshipDirection.equals("OUTGOING") || fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING"))) continue;
            return fieldInfo;
        }
        return null;
    }

    public Set<FieldInfo> candidateRelationshipFields(String relationshipName, String relationshipDirection, boolean strict) {
        HashSet<FieldInfo> candidateFields = new HashSet<FieldInfo>();
        for (FieldInfo fieldInfo : this.relationshipFields()) {
            String relationship = strict ? fieldInfo.relationshipTypeAnnotation() : fieldInfo.relationship();
            if (!relationshipName.equalsIgnoreCase(relationship) || (!fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING") && !fieldInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED") || !relationshipDirection.equals("INCOMING")) && (!relationshipDirection.equals("OUTGOING") || fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING"))) continue;
            candidateFields.add(fieldInfo);
        }
        return candidateFields;
    }

    public FieldInfo relationshipFieldByName(String fieldName) {
        for (FieldInfo fieldInfo : this.relationshipFields()) {
            if (!fieldInfo.getName().equalsIgnoreCase(fieldName)) continue;
            return fieldInfo;
        }
        return null;
    }

    public Field getField(FieldInfo fieldInfo) {
        Field field = this.fieldInfoFields.get(fieldInfo);
        if (field != null) {
            return field;
        }
        try {
            field = this.cls.getDeclaredField(fieldInfo.getName());
            this.fieldInfoFields.put(fieldInfo, field);
            return field;
        }
        catch (NoSuchFieldException e) {
            if (this.directSuperclass() != null) {
                field = this.directSuperclass().getField(fieldInfo);
                this.fieldInfoFields.put(fieldInfo, field);
                return field;
            }
            throw new RuntimeException("Field " + fieldInfo.getName() + " not found in class " + this.name() + " or any of its superclasses");
        }
    }

    @Deprecated
    public Method getMethod(MethodInfo methodInfo) {
        return methodInfo.getMethod();
    }

    public List<FieldInfo> findFields(Class<?> fieldType) {
        String fieldSignature = fieldType.getName();
        Predicate<FieldInfo> matchesType = f -> f.getTypeDescriptor().equals(fieldSignature);
        return this.fieldsInfo().fields().stream().filter(matchesType).collect(Collectors.toList());
    }

    public List<FieldInfo> findFields(String annotation) {
        Predicate<FieldInfo> hasAnnotation = f -> f.hasAnnotation(annotation);
        return this.fieldsInfo().fields().stream().filter(hasAnnotation).collect(Collectors.toList());
    }

    public List<FieldInfo> findIterableFields() {
        Predicate<FieldInfo> isIterable = f -> {
            Class<?> type = this.getField((FieldInfo)f).getType();
            return type.isArray() || Iterable.class.isAssignableFrom(type);
        };
        try {
            return this.fieldsInfo().fields().stream().filter(isIterable).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<FieldInfo> findIterableFields(Class iteratedType) {
        if (this.iterableFieldsForType.containsKey(iteratedType)) {
            return this.iterableFieldsForType.get(iteratedType);
        }
        String typeSignature = iteratedType.getName();
        String arrayOfTypeSignature = typeSignature + "[]";
        Predicate<FieldInfo> isIterableOfType = f -> {
            String fieldType = f.getTypeDescriptor();
            boolean isMatchingArray = f.isArray() && (fieldType.equals(arrayOfTypeSignature) || f.isParameterisedTypeOf(iteratedType));
            boolean isMatchingIterable = f.isIterable() && (fieldType.equals(typeSignature) || f.isParameterisedTypeOf(iteratedType));
            return isMatchingArray || isMatchingIterable;
        };
        return this.fieldsInfo().fields().stream().filter(isIterableOfType).collect(Collectors.toList());
    }

    public List<FieldInfo> findIterableFields(Class iteratedType, String relationshipType, String relationshipDirection, boolean strict) {
        ArrayList<FieldInfo> iterableFields = new ArrayList<FieldInfo>();
        for (FieldInfo fieldInfo : this.findIterableFields(iteratedType)) {
            String relationship = strict ? fieldInfo.relationshipTypeAnnotation() : fieldInfo.relationship();
            if (!relationshipType.equals(relationship) || (!fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING") && !fieldInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED") || !relationshipDirection.equals("INCOMING")) && (!relationshipDirection.equals("OUTGOING") || fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING"))) continue;
            iterableFields.add(fieldInfo);
        }
        return iterableFields;
    }

    public boolean isTransient() {
        return this.annotationsInfo.get(Transient.class) != null;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    boolean isSubclassOf(ClassInfo classInfo) {
        if (classInfo == null) {
            return false;
        }
        if (this == classInfo) {
            return true;
        }
        for (ClassInfo subclass : classInfo.directSubclasses()) {
            if (!this.isSubclassOf(subclass)) continue;
            return true;
        }
        return this.indirectSuperClasses.stream().anyMatch(c -> c.getUnderlyingClass() == classInfo.getUnderlyingClass());
    }

    public Class<?> getUnderlyingClass() {
        return this.cls;
    }

    Class getTypeParameterDescriptorForRelationship(String relationshipType, String relationshipDirection) {
        boolean STRICT_MODE = true;
        boolean INFERRED_MODE = false;
        try {
            FieldInfo fieldInfo = this.relationshipField(relationshipType, relationshipDirection, true);
            if (fieldInfo != null && fieldInfo.getTypeDescriptor() != null) {
                return DescriptorMappings.getType(fieldInfo.getTypeDescriptor());
            }
            if (!relationshipDirection.equals("INCOMING") && (fieldInfo = this.relationshipField(relationshipType, relationshipDirection, false)) != null && fieldInfo.getTypeDescriptor() != null) {
                return DescriptorMappings.getType(fieldInfo.getTypeDescriptor());
            }
        }
        catch (RuntimeException e) {
            LOGGER.debug("Could not get {} class type for relationshipType {} and relationshipDirection {} ", new Object[]{this.className, relationshipType, relationshipDirection});
        }
        return null;
    }

    public boolean containsIndexes() {
        return !this.getIndexFields().isEmpty() || !this.getCompositeIndexes().isEmpty();
    }

    public Collection<FieldInfo> getIndexFields() {
        if (this.indexFields == null) {
            this.indexFields = this.initIndexFields();
        }
        return this.indexFields.values();
    }

    private synchronized Map<String, FieldInfo> initIndexFields() {
        Field[] declaredFields;
        HashMap<String, FieldInfo> indexes = new HashMap<String, FieldInfo>();
        try {
            declaredFields = Class.forName(this.className, false, Thread.currentThread().getContextClassLoader()).getDeclaredFields();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not reflectively read declared fields", e);
        }
        for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
            if (!ClassInfo.isDeclaredField(declaredFields, fieldInfo.getName()) || !fieldInfo.hasAnnotation(Index.class) && !fieldInfo.hasAnnotation(Id.class)) continue;
            String propertyValue = fieldInfo.property();
            if (fieldInfo.hasAnnotation(Property.class.getName())) {
                propertyValue = fieldInfo.property();
            }
            indexes.put(propertyValue, fieldInfo);
        }
        return indexes;
    }

    private static boolean isDeclaredField(Field[] declaredFields, String name) {
        for (Field field : declaredFields) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Collection<CompositeIndex> getCompositeIndexes() {
        if (this.compositeIndexes == null) {
            this.compositeIndexes = this.initCompositeIndexFields();
        }
        return this.compositeIndexes;
    }

    private synchronized Collection<CompositeIndex> initCompositeIndexFields() {
        this.propertyFields();
        if (this.cls == null) {
            try {
                this.cls = Class.forName(this.className, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not get annotation info for class " + this.className, e);
            }
        }
        CompositeIndex[] annotations = (CompositeIndex[])this.cls.getDeclaredAnnotationsByType(CompositeIndex.class);
        ArrayList<CompositeIndex> result = new ArrayList<CompositeIndex>(annotations.length);
        for (CompositeIndex annotation : annotations) {
            String[] properties;
            String[] stringArray = properties = annotation.value().length > 0 ? annotation.value() : annotation.properties();
            if (properties.length < 1) {
                throw new MetadataException("Incorrect CompositeIndex definition on " + this.className + ". Provide at least 1 property");
            }
            for (String property : properties) {
                FieldInfo fieldInfo = this.propertyFields.get(property);
                if (fieldInfo != null) continue;
                throw new MetadataException("Incorrect CompositeIndex definition on " + this.className + ". Property " + property + " does not exists.");
            }
            result.add(annotation);
        }
        return result;
    }

    public FieldInfo primaryIndexField() {
        if (!this.primaryIndexFieldChecked && this.primaryIndexField == null) {
            Collection<FieldInfo> primaryIndexFields = this.getFieldInfos(this::isPrimaryIndexField);
            if (primaryIndexFields.size() > 1) {
                throw new MetadataException("Only one @Id / @Index(primary=true, unique=true) annotation is allowed in a class hierarchy. Please check annotations in the class " + this.name() + " or its parents");
            }
            if (primaryIndexFields.size() == 1) {
                this.primaryIndexField = primaryIndexFields.iterator().next();
                AnnotationInfo generatedValueAnnotation = this.primaryIndexField.getAnnotations().get(GeneratedValue.class);
                if (generatedValueAnnotation != null) {
                    GeneratedValue value = (GeneratedValue)generatedValueAnnotation.getAnnotation();
                    this.idStrategyClass = value.strategy();
                    this.instantiateIdStrategy();
                }
            }
            this.validateIdGenerationConfig();
            this.primaryIndexFieldChecked = true;
        }
        return this.primaryIndexField;
    }

    public boolean hasPrimaryIndexField() {
        if (!this.primaryIndexFieldChecked) {
            this.primaryIndexField();
        }
        return this.primaryIndexField != null;
    }

    private boolean isPrimaryIndexField(FieldInfo fieldInfo) {
        boolean hasIdAnnotation = fieldInfo.hasAnnotation(Id.class);
        boolean hasStrategyOtherThanInternal = !fieldInfo.hasAnnotation(GeneratedValue.class) || !((GeneratedValue)fieldInfo.getAnnotations().get(GeneratedValue.class).getAnnotation()).strategy().equals(InternalIdStrategy.class);
        boolean hasPrimaryIndexAnnotation = fieldInfo.hasAnnotation(Index.class) && ((Index)fieldInfo.getAnnotations().get(Index.class).getAnnotation()).primary();
        return hasIdAnnotation && hasStrategyOtherThanInternal || hasPrimaryIndexAnnotation;
    }

    private void instantiateIdStrategy() {
        try {
            this.idStrategy = this.idStrategyClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.debug("Could not instantiate {}. Expecting this to be registered manually.", this.idStrategyClass);
        }
    }

    private void validateIdGenerationConfig() {
        this.fieldsInfo().fields().forEach(info -> {
            if (info.hasAnnotation(GeneratedValue.class) && !info.hasAnnotation(Id.class)) {
                throw new MetadataException("The type of @Generated field in class " + this.className + " must be also annotated with @Id.");
            }
        });
        if (UuidStrategy.class.equals(this.idStrategyClass) && !this.primaryIndexField.isTypeOf(UUID.class) && !this.primaryIndexField.isTypeOf(String.class)) {
            throw new MetadataException("The type of " + this.primaryIndexField.getName() + " in class " + this.className + " must be of type java.lang.UUID or java.lang.String because it has an UUID generation strategy.");
        }
    }

    public IdStrategy idStrategy() {
        if (!this.primaryIndexFieldChecked) {
            this.primaryIndexField();
        }
        return this.idStrategy;
    }

    public Class<? extends IdStrategy> idStrategyClass() {
        return this.idStrategyClass;
    }

    public void registerIdGenerationStrategy(IdStrategy strategy) {
        if (!strategy.getClass().equals(this.idStrategyClass)) {
            throw new IllegalArgumentException("Strategy " + strategy + " is not an instance of " + this.idStrategyClass);
        }
        this.idStrategy = strategy;
    }

    public synchronized MethodInfo postLoadMethodOrNull() {
        this.initPostLoadMethod();
        return this.postLoadMethod;
    }

    private synchronized void initPostLoadMethod() {
        if (this.isPostLoadMethodMapped) {
            return;
        }
        Collection<MethodInfo> possiblePostLoadMethods = this.methodsInfo.findMethodInfoBy(methodInfo -> methodInfo.hasAnnotation(PostLoad.class));
        if (possiblePostLoadMethods.size() > 1) {
            throw new MetadataException(String.format("Cannot have more than one post load method annotated with @PostLoad for class '%s'", this.className));
        }
        this.postLoadMethod = possiblePostLoadMethods.stream().findFirst().orElse(null);
        this.isPostLoadMethodMapped = true;
    }

    public FieldInfo getFieldInfo(String propertyName) {
        FieldInfo optionalLabelField = this.labelFieldOrNull();
        if (optionalLabelField != null && optionalLabelField.getName().equals(propertyName)) {
            return optionalLabelField;
        }
        FieldInfo propertyField = this.propertyField(propertyName);
        if (propertyField != null) {
            return propertyField;
        }
        return this.fieldsInfo.get(propertyName);
    }

    public FieldInfo getEndNodeReader() {
        if (this.isRelationshipEntity()) {
            for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                if (fieldInfo.getAnnotations().get(EndNode.class) == null) continue;
                return fieldInfo;
            }
            LOGGER.warn("Failed to find an @EndNode on {}", (Object)this.name());
        }
        return null;
    }

    public FieldInfo getStartNodeReader() {
        if (this.isRelationshipEntity()) {
            for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                if (fieldInfo.getAnnotations().get(StartNode.class) == null) continue;
                return fieldInfo;
            }
            LOGGER.warn("Failed to find an @StartNode on {}", (Object)this.name());
        }
        return null;
    }

    public boolean hasRequiredFields() {
        return !this.requiredFields().isEmpty();
    }

    public Collection<FieldInfo> requiredFields() {
        if (this.requiredFields == null) {
            this.requiredFields = new ArrayList<FieldInfo>();
            for (FieldInfo fieldInfo : this.propertyFields()) {
                if (!fieldInfo.getAnnotations().has(Required.class)) continue;
                this.requiredFields.add(fieldInfo);
            }
        }
        return this.requiredFields;
    }

    public boolean hasVersionField() {
        this.initVersionField();
        return this.versionField.isPresent();
    }

    public FieldInfo getVersionField() {
        this.initVersionField();
        return this.versionField.orElse(null);
    }

    private synchronized void initVersionField() {
        if (this.versionField != null) {
            return;
        }
        Collection<FieldInfo> fields = this.getFieldInfos(FieldInfo::isVersionField);
        if (fields.size() > 1) {
            throw new MetadataException("Only one version field is allowed, found " + fields);
        }
        Iterator<FieldInfo> iterator = fields.iterator();
        this.versionField = iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
    }

    public Object readPrimaryIndexValueOf(Object entity) {
        Objects.requireNonNull(entity, "Entity to read from must not be null.");
        Object value = null;
        if (this.hasPrimaryIndexField()) {
            value = this.primaryIndexField().read(entity);
        }
        return value;
    }

    public Function<Object, Optional<Object>> getPrimaryIndexOrIdReader() {
        Function<Object, Optional<Object>> reader = this.hasPrimaryIndexField() ? t -> Optional.ofNullable(this.readPrimaryIndexValueOf(t)) : t -> Optional.ofNullable(this.identityField().read(t));
        return reader;
    }

    static Object getInstanceOrDelegate(Object instance, Field delegateHolder) {
        if (delegateHolder == null) {
            return instance;
        }
        return AccessController.doPrivileged(() -> {
            try {
                delegateHolder.setAccessible(true);
                return delegateHolder.get(instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public String toString() {
        return "ClassInfo{className='" + this.className + '\'' + ", neo4jName='" + this.neo4jName + '\'' + '}';
    }
}

