/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ForkedProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class RelationshipEncoderStep
extends ForkedProcessorStep<Batch<InputRelationship, RelationshipRecord>> {
    private final NodeRelationshipCache cache;

    public RelationshipEncoderStep(StageControl control, Configuration config, NodeRelationshipCache cache) {
        super(control, "RELATIONSHIP", config, 0);
        this.cache = cache;
    }

    @Override
    protected void forkedProcess(int id, int processors, Batch<InputRelationship, RelationshipRecord> batch) {
        for (int i = 0; i < ((RelationshipRecord[])batch.records).length; ++i) {
            RelationshipRecord relationship = ((RelationshipRecord[])batch.records)[i];
            long startNode = relationship.getFirstNode();
            long endNode = relationship.getSecondNode();
            if (!relationship.inUse()) continue;
            boolean loop = startNode == endNode;
            int typeId = relationship.getType();
            if (startNode % (long)processors == (long)id) {
                long firstNextRel = this.cache.getAndPutRelationship(startNode, typeId, loop ? Direction.BOTH : Direction.OUTGOING, relationship.getId(), true);
                relationship.setFirstNextRel(firstNextRel);
                if (loop) {
                    relationship.setSecondNextRel(firstNextRel);
                }
            }
            if (loop || endNode % (long)processors != (long)id) continue;
            relationship.setSecondNextRel(this.cache.getAndPutRelationship(endNode, typeId, Direction.INCOMING, relationship.getId(), true));
        }
    }
}

