/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.util.Arrays;
import java.util.Objects;

public class IdRange {
    private final long[] defragIds;
    private final long rangeStart;
    private final int rangeLength;

    public IdRange(long[] defragIds, long rangeStart, int rangeLength) {
        this.defragIds = defragIds;
        this.rangeStart = rangeStart;
        this.rangeLength = rangeLength;
    }

    public long[] getDefragIds() {
        return this.defragIds;
    }

    public long getRangeStart() {
        return this.rangeStart;
    }

    public int getRangeLength() {
        return this.rangeLength;
    }

    public String toString() {
        return "IdRange[" + this.rangeStart + "-" + (this.rangeStart + (long)this.rangeLength - 1L) + ", defrag " + Arrays.toString(this.defragIds) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdRange idRange = (IdRange)o;
        return this.rangeStart == idRange.rangeStart && this.rangeLength == idRange.rangeLength && Arrays.equals(this.defragIds, idRange.defragIds);
    }

    public int hashCode() {
        return Objects.hash(this.defragIds, this.rangeStart, this.rangeLength);
    }
}

