/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs.watcher;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.io.fs.watcher.FileWatchEventListener;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.fs.watcher.resource.WatchedFile;
import org.neo4j.io.fs.watcher.resource.WatchedResource;

public class DefaultFileSystemWatcher
implements FileWatcher {
    private static final WatchEvent.Kind[] OBSERVED_EVENTS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    private final WatchService watchService;
    private final List<FileWatchEventListener> listeners = new CopyOnWriteArrayList<FileWatchEventListener>();
    private final Map<Path, SharedWatchedFile> watchedFiles = new ConcurrentHashMap<Path, SharedWatchedFile>();
    private volatile boolean watch;

    public DefaultFileSystemWatcher(WatchService watchService) {
        this.watchService = watchService;
    }

    @Override
    public WatchedResource watch(Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("File `%s` is not a directory. Only directories can be registered to be monitored.", path.toAbsolutePath().normalize()));
        }
        return this.watchedFiles.compute(path.toAbsolutePath(), (key, watchedFile) -> watchedFile != null && watchedFile.share() ? watchedFile : new SharedWatchedFile(this.uncheckedRegister((Path)key), (Path)key, () -> this.watchedFiles.remove(key)));
    }

    @Override
    public void startWatching() throws InterruptedException {
        this.watch = true;
        while (this.watch) {
            WatchKey key = this.watchService.take();
            if (key == null) continue;
            List<WatchEvent<?>> watchEvents = key.pollEvents();
            for (WatchEvent<?> watchEvent : watchEvents) {
                WatchEvent.Kind<?> kind = watchEvent.kind();
                if (StandardWatchEventKinds.ENTRY_MODIFY == kind) {
                    this.notifyAboutModification(key, watchEvent);
                }
                if (StandardWatchEventKinds.ENTRY_DELETE != kind) continue;
                this.notifyAboutDeletion(key, watchEvent);
            }
            key.reset();
        }
    }

    @Override
    public void stopWatching() {
        this.watch = false;
    }

    @Override
    public void addFileWatchEventListener(FileWatchEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeFileWatchEventListener(FileWatchEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void close() throws IOException {
        this.stopWatching();
        this.watchService.close();
    }

    private void notifyAboutModification(WatchKey key, WatchEvent<?> watchEvent) {
        String context = DefaultFileSystemWatcher.getContext(watchEvent);
        if (StringUtils.isNotEmpty((CharSequence)context)) {
            for (FileWatchEventListener listener : this.listeners) {
                listener.fileModified(key, context);
            }
        }
    }

    private void notifyAboutDeletion(WatchKey key, WatchEvent<?> watchEvent) {
        String context = DefaultFileSystemWatcher.getContext(watchEvent);
        if (StringUtils.isNotEmpty((CharSequence)context)) {
            for (FileWatchEventListener listener : this.listeners) {
                listener.fileDeleted(key, context);
            }
        }
    }

    private WatchKey uncheckedRegister(Path path) {
        try {
            return path.register(this.watchService, OBSERVED_EVENTS, SensitivityWatchEventModifier.HIGH);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String getContext(WatchEvent<?> watchEvent) {
        return Objects.toString(watchEvent.context(), "");
    }

    private static class SharedWatchedFile
    extends WatchedFile {
        private final Runnable closeAction;
        private int refCount = 1;
        private boolean closed;

        private SharedWatchedFile(WatchKey watchKey, Path path, Runnable closeAction) {
            super(watchKey, path);
            this.closeAction = closeAction;
        }

        @Override
        public synchronized void close() {
            if (--this.refCount == 0) {
                super.close();
                this.closeAction.run();
                this.closed = true;
            }
        }

        synchronized boolean share() {
            if (!this.closed) {
                ++this.refCount;
            }
            return !this.closed;
        }
    }
}

