/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapper;
import org.neo4j.util.FeatureToggles;

public class StoreFileChannel
implements StoreChannel {
    private static final boolean PRINT_REFLECTION_EXCEPTIONS = FeatureToggles.flag(SingleFilePageSwapper.class, (String)"printReflectionExceptions", (boolean)false);
    private static final Class<?> CLS_FILE_CHANNEL_IMPL = StoreFileChannel.getInternalFileChannelClass();
    private static final MethodHandle POSITION_LOCK_GETTER = StoreFileChannel.getPositionLockGetter();
    private static final MethodHandle MAKE_CHANNEL_UNINTERRUPTIBLE = StoreFileChannel.getUninterruptibleSetter();
    private static final MethodHandle CHANNEL_GET_FD = StoreFileChannel.getChannelFileDescriptorGetter();
    private static final MethodHandle DESCRIPTOR_GET_FD = StoreFileChannel.getFileDescriptorGetter();
    private final FileChannel channel;

    private static Class<?> getInternalFileChannelClass() {
        Class<?> cls;
        block2: {
            cls = null;
            try {
                cls = Class.forName("sun.nio.ch.FileChannelImpl");
            }
            catch (Throwable throwable) {
                if (!PRINT_REFLECTION_EXCEPTIONS) break block2;
                throwable.printStackTrace();
            }
        }
        return cls;
    }

    private static MethodHandle unreflect(ThrowingFunction<MethodHandles.Lookup, MethodHandle, Exception> unreflector) {
        try {
            if (CLS_FILE_CHANNEL_IMPL != null) {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                return (MethodHandle)unreflector.apply((Object)lookup);
            }
            return null;
        }
        catch (Throwable e) {
            if (PRINT_REFLECTION_EXCEPTIONS) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static MethodHandle getUninterruptibleSetter() {
        return StoreFileChannel.unreflect((ThrowingFunction<MethodHandles.Lookup, MethodHandle, Exception>)((ThrowingFunction)lookup -> {
            Method uninterruptibleSetter = CLS_FILE_CHANNEL_IMPL.getMethod("setUninterruptible", new Class[0]);
            return lookup.unreflect(uninterruptibleSetter);
        }));
    }

    private static MethodHandle getPositionLockGetter() {
        return StoreFileChannel.unreflect((ThrowingFunction<MethodHandles.Lookup, MethodHandle, Exception>)((ThrowingFunction)lookup -> {
            Field positionLock = FieldUtils.getDeclaredField(CLS_FILE_CHANNEL_IMPL, (String)"positionLock", (boolean)true);
            return lookup.unreflectGetter(positionLock);
        }));
    }

    private static MethodHandle getChannelFileDescriptorGetter() {
        return StoreFileChannel.unreflect((ThrowingFunction<MethodHandles.Lookup, MethodHandle, Exception>)((ThrowingFunction)lookup -> {
            Field fd = FieldUtils.getDeclaredField(CLS_FILE_CHANNEL_IMPL, (String)"fd", (boolean)true);
            return lookup.unreflectGetter(fd);
        }));
    }

    private static MethodHandle getFileDescriptorGetter() {
        return StoreFileChannel.unreflect((ThrowingFunction<MethodHandles.Lookup, MethodHandle, Exception>)((ThrowingFunction)lookup -> {
            Field fd = FieldUtils.getDeclaredField(FileDescriptor.class, (String)"fd", (boolean)true);
            return lookup.unreflectGetter(fd);
        }));
    }

    public StoreFileChannel(FileChannel channel) {
        this.channel = channel;
    }

    public StoreFileChannel(StoreFileChannel channel) {
        this.channel = channel.channel;
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.channel.write(srcs);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.channel.write(srcs, offset, length);
    }

    @Override
    public void writeAll(ByteBuffer src, long position) throws IOException {
        int bytesWritten;
        long filePosition = position;
        long expectedEndPosition = filePosition + (long)src.limit() - (long)src.position();
        while ((filePosition += (long)(bytesWritten = this.channel.write(src, filePosition))) < expectedEndPosition) {
            if (bytesWritten >= 0) continue;
            throw new IOException("Unable to write to disk, reported bytes written was " + bytesWritten);
        }
    }

    @Override
    public void writeAll(ByteBuffer src) throws IOException {
        int bytesWritten;
        long bytesToWrite = src.limit() - src.position();
        while ((bytesToWrite -= (long)(bytesWritten = this.write(src))) > 0L) {
            if (bytesWritten >= 0) continue;
            throw new IOException("Unable to write to disk, reported bytes written was " + bytesWritten);
        }
    }

    @Override
    public StoreFileChannel truncate(long size) throws IOException {
        this.channel.truncate(size);
        return this;
    }

    @Override
    public int getFileDescriptor() {
        if (this.channel.getClass() != CLS_FILE_CHANNEL_IMPL || CHANNEL_GET_FD == null || DESCRIPTOR_GET_FD == null) {
            return -1;
        }
        try {
            FileDescriptor fd = CHANNEL_GET_FD.invoke(this.channel);
            return DESCRIPTOR_GET_FD.invoke(fd);
        }
        catch (Throwable throwable) {
            if (PRINT_REFLECTION_EXCEPTIONS) {
                throwable.printStackTrace();
            }
            return -1;
        }
    }

    @Override
    public boolean hasPositionLock() {
        return POSITION_LOCK_GETTER != null && this.channel.getClass() == CLS_FILE_CHANNEL_IMPL;
    }

    @Override
    public Object getPositionLock() {
        if (POSITION_LOCK_GETTER == null) {
            return null;
        }
        try {
            return POSITION_LOCK_GETTER.invoke(this.channel);
        }
        catch (Throwable th) {
            throw new LinkageError("Cannot get FileChannel.positionLock", th);
        }
    }

    @Override
    public void tryMakeUninterruptible() {
        if (MAKE_CHANNEL_UNINTERRUPTIBLE != null && this.channel.getClass() == CLS_FILE_CHANNEL_IMPL) {
            try {
                MAKE_CHANNEL_UNINTERRUPTIBLE.invoke(this.channel);
            }
            catch (Throwable t) {
                throw new LinkageError("No setter for uninterruptible flag", t);
            }
        }
    }

    @Override
    public StoreFileChannel position(long newPosition) throws IOException {
        this.channel.position(newPosition);
        return this;
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        return this.channel.read(dst, position);
    }

    @Override
    public void readAll(ByteBuffer dst) throws IOException {
        while (dst.hasRemaining()) {
            int bytesRead = this.channel.read(dst);
            if (bytesRead >= 0) continue;
            throw new IllegalStateException("Channel has reached end-of-stream.");
        }
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.channel.force(metaData);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.channel.read(dsts, offset, length);
    }

    @Override
    public long position() throws IOException {
        return this.channel.position();
    }

    @Override
    public FileLock tryLock() throws IOException {
        return this.channel.tryLock();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.channel.read(dsts);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.channel.write(src);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public void flush() throws IOException {
        this.force(false);
    }
}

