/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.MultiPartElement;
import org.neo4j.cypherdsl.core.MultiPartQuery;
import org.neo4j.cypherdsl.core.Neo4jVersion;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.annotations.CheckReturnValue;

@API(status=API.Status.STABLE, since="2020.1.2")
@Neo4jVersion(minimum="4.0.0")
public interface ExposesSubqueryCall {
    @NotNull
    @CheckReturnValue
    default public BuildableSubquery call(Statement statement) {
        MultiPartQuery multiPartQuery;
        List<MultiPartElement> parts;
        if (statement instanceof MultiPartQuery && !(parts = (multiPartQuery = (MultiPartQuery)statement).getParts()).isEmpty() && parts.get(0).isImporting()) {
            return this.call(multiPartQuery.stripFirst(), parts.get(0).getImports());
        }
        return this.call(statement, new IdentifiableElement[0]);
    }

    @NotNull
    @CheckReturnValue
    default public BuildableSubquery call(Statement statement, String ... imports) {
        return this.call(statement, (IdentifiableElement[])Arrays.stream(imports).map(SymbolicName::of).toArray(SymbolicName[]::new));
    }

    @NotNull
    @CheckReturnValue
    public BuildableSubquery call(Statement var1, IdentifiableElement ... var2);

    @NotNull
    @CheckReturnValue
    default public BuildableSubquery callInTransactions(Statement statement) {
        return this.callInTransactions(statement, (Integer)null);
    }

    @NotNull
    @CheckReturnValue
    public BuildableSubquery callRawCypher(String var1, Object ... var2);

    @NotNull
    @CheckReturnValue
    default public BuildableSubquery callInTransactions(Statement statement, Integer rows) {
        MultiPartQuery multiPartQuery;
        List<MultiPartElement> parts;
        if (statement instanceof MultiPartQuery && !(parts = (multiPartQuery = (MultiPartQuery)statement).getParts()).isEmpty() && parts.get(0).isImporting()) {
            return this.callInTransactions(multiPartQuery.stripFirst(), rows, parts.get(0).getImports());
        }
        return this.callInTransactions(statement, rows, new IdentifiableElement[0]);
    }

    @NotNull
    @CheckReturnValue
    default public BuildableSubquery callInTransactions(Statement statement, String ... imports) {
        return this.callInTransactions(statement, (Integer)null, (IdentifiableElement[])Arrays.stream(imports).map(SymbolicName::of).toArray(SymbolicName[]::new));
    }

    @NotNull
    @CheckReturnValue
    default public BuildableSubquery callInTransactions(Statement statement, Integer rows, String ... imports) {
        return this.callInTransactions(statement, rows, (IdentifiableElement[])Arrays.stream(imports).map(SymbolicName::of).toArray(SymbolicName[]::new));
    }

    default public BuildableSubquery callInTransactions(Statement statement, IdentifiableElement ... imports) {
        return this.callInTransactions(statement, (Integer)null, imports);
    }

    @NotNull
    @CheckReturnValue
    public BuildableSubquery callInTransactions(Statement var1, Integer var2, IdentifiableElement ... var3);

    public static interface BuildableSubquery
    extends StatementBuilder.OngoingReadingWithoutWhere,
    StatementBuilder.BuildableStatement<Statement> {
    }
}

