/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v44.runtime;

import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.routing.RoutingTableGetter;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v44.messaging.request.RouteMessage;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class ReadyState
extends org.neo4j.bolt.v43.runtime.ReadyState {
    public ReadyState(RoutingTableGetter routingTableGetter) {
        super(routingTableGetter);
    }

    @Override
    public BoltStateMachineState processUnsafe(RequestMessage message, StateMachineContext context) throws Exception {
        if (message instanceof RouteMessage || message instanceof org.neo4j.bolt.v44.messaging.request.RunMessage || message instanceof org.neo4j.bolt.v44.messaging.request.BeginMessage) {
            return super.processUnsafe(message, context);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BoltStateMachineState processRouteMessage(org.neo4j.bolt.v43.messaging.request.RouteMessage message, StateMachineContext context) throws Exception {
        RouteMessage routeMessage = (RouteMessage)message;
        context.impersonateUser(this.authenticateImpersonation(context, routeMessage.impersonatedUser()));
        try {
            BoltStateMachineState boltStateMachineState = super.processRouteMessage(message, context);
            return boltStateMachineState;
        }
        finally {
            context.impersonateUser(null);
        }
    }

    @Override
    protected void onRoutingTableReceived(StateMachineContext context, org.neo4j.bolt.v43.messaging.request.RouteMessage message, MapValue routingTable) {
        String databaseName = message.getDatabaseName();
        if (databaseName == null || "".equals(message.getDatabaseName())) {
            databaseName = context.getDefaultDatabase();
        }
        super.onRoutingTableReceived(context, message, routingTable.updatedWith("db", (AnyValue)Values.stringValue((String)databaseName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BoltStateMachineState processRunMessage(RunMessage message, StateMachineContext context) throws Exception {
        org.neo4j.bolt.v44.messaging.request.RunMessage runMessage = (org.neo4j.bolt.v44.messaging.request.RunMessage)message;
        context.impersonateUser(this.authenticateImpersonation(context, runMessage.impersonatedUser()));
        try {
            BoltStateMachineState boltStateMachineState = super.processRunMessage(message, context);
            return boltStateMachineState;
        }
        finally {
            context.impersonateUser(null);
        }
    }

    @Override
    protected BoltStateMachineState processBeginMessage(BeginMessage message, StateMachineContext context) throws Exception {
        org.neo4j.bolt.v44.messaging.request.BeginMessage beginMessage = (org.neo4j.bolt.v44.messaging.request.BeginMessage)message;
        context.impersonateUser(this.authenticateImpersonation(context, beginMessage.impersonatedUser()));
        return super.processBeginMessage(message, context);
    }

    private LoginContext authenticateImpersonation(StateMachineContext context, String username) throws AuthenticationException {
        if (username != null) {
            return context.boltSpi().impersonate(context.getLoginContext(), username);
        }
        return null;
    }
}

